/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import org.springframework.util.ClassUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Limit {
    public static Limit unlimited() {
        return Unlimited.INSTANCE;
    }

    public static Limit of(int max) {
        return new Limited(max);
    }

    public int max();

    public boolean isLimited();

    default public boolean isUnlimited() {
        return !this.isLimited();
    }

    public static final class Unlimited
    implements Limit {
        static final Limit INSTANCE = new Unlimited();

        Unlimited() {
        }

        @Override
        public int max() {
            throw new IllegalStateException("Unlimited does not define 'max'. Please check 'isLimited' before attempting to read 'max'");
        }

        @Override
        public boolean isLimited() {
            return false;
        }
    }

    public static final class Limited
    implements Limit {
        private final int max;

        Limited(int max) {
            this.max = max;
        }

        @Override
        public int max() {
            return this.max;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!ClassUtils.isAssignable(Limit.class, obj.getClass())) {
                return false;
            }
            Limit that = (Limit)obj;
            if (this.isUnlimited() && that.isUnlimited()) {
                return true;
            }
            return this.max() == that.max();
        }

        public int hashCode() {
            return this.max ^ this.max >>> 32;
        }
    }
}

