/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Collection;
import org.springframework.data.domain.DoubleVector;
import org.springframework.data.domain.FloatVector;
import org.springframework.data.domain.NumberVector;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public interface Vector {
    public static Vector of(float ... values) {
        Assert.notNull((Object)values, (String)"float vector values must not be null");
        return FloatVector.copy(values);
    }

    public static Vector of(double ... values) {
        Assert.notNull((Object)values, (String)"double vector values must not be null");
        return DoubleVector.copy(values);
    }

    public static Vector of(Collection<? extends Number> values) {
        Assert.notNull(values, (String)"Vector values must not be null");
        if (values.isEmpty()) {
            return NumberVector.EMPTY;
        }
        Class cet = CollectionUtils.findCommonElementType(values);
        if (cet == Double.class) {
            return DoubleVector.copy(values);
        }
        if (cet == Float.class) {
            return FloatVector.copy(values);
        }
        return NumberVector.copy(values);
    }

    public static Vector unsafe(float[] values) {
        Assert.notNull((Object)values, (String)"float vector values must not be null");
        return new FloatVector(values);
    }

    public static Vector unsafe(double[] values) {
        Assert.notNull((Object)values, (String)"double vector values must not be null");
        return new DoubleVector(values);
    }

    public Class<? extends Number> getType();

    public Object getSource();

    public int size();

    public float[] toFloatArray();

    public double[] toDoubleArray();
}

