/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Parent;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleElasticsearchPersistentEntity<T>
extends BasicPersistentEntity<T, ElasticsearchPersistentProperty>
implements ElasticsearchPersistentEntity<T>,
ApplicationContextAware {
    private final StandardEvaluationContext context = new StandardEvaluationContext();
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private String indexName;
    private String indexType;
    private boolean useServerConfiguration;
    private short shards;
    private short replicas;
    private String refreshInterval;
    private String indexStoreType;
    private String parentType;
    private ElasticsearchPersistentProperty parentIdProperty;
    private String settingPath;
    private boolean createIndexAndMapping;

    public SimpleElasticsearchPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        Class clazz = typeInformation.getType();
        if (clazz.isAnnotationPresent(Document.class)) {
            Document document = clazz.getAnnotation(Document.class);
            Assert.hasText((String)document.indexName(), (String)" Unknown indexName. Make sure the indexName is defined. e.g @Document(indexName=\"foo\")");
            this.indexName = document.indexName();
            this.indexType = StringUtils.hasText((String)document.type()) ? document.type() : clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
            this.useServerConfiguration = document.useServerConfiguration();
            this.shards = document.shards();
            this.replicas = document.replicas();
            this.refreshInterval = document.refreshInterval();
            this.indexStoreType = document.indexStoreType();
            this.createIndexAndMapping = document.createIndex();
        }
        if (clazz.isAnnotationPresent(Setting.class)) {
            this.settingPath = typeInformation.getType().getAnnotation(Setting.class).settingPath();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    @Override
    public String getIndexName() {
        Expression expression = this.parser.parseExpression(this.indexName, ParserContext.TEMPLATE_EXPRESSION);
        return (String)expression.getValue((EvaluationContext)this.context, String.class);
    }

    @Override
    public String getIndexType() {
        Expression expression = this.parser.parseExpression(this.indexType, ParserContext.TEMPLATE_EXPRESSION);
        return (String)expression.getValue((EvaluationContext)this.context, String.class);
    }

    @Override
    public String getIndexStoreType() {
        return this.indexStoreType;
    }

    @Override
    public short getShards() {
        return this.shards;
    }

    @Override
    public short getReplicas() {
        return this.replicas;
    }

    @Override
    public boolean isUseServerConfiguration() {
        return this.useServerConfiguration;
    }

    @Override
    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public String getParentType() {
        return this.parentType;
    }

    @Override
    public ElasticsearchPersistentProperty getParentIdProperty() {
        return this.parentIdProperty;
    }

    @Override
    public String settingPath() {
        return this.settingPath;
    }

    @Override
    public boolean isCreateIndexAndMapping() {
        return this.createIndexAndMapping;
    }

    public void addPersistentProperty(ElasticsearchPersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
        Parent annotation = (Parent)property.findAnnotation(Parent.class);
        if (annotation != null) {
            Assert.isNull((Object)this.parentIdProperty, (String)"Only one field can hold a @Parent annotation");
            Assert.isNull((Object)this.parentType, (String)"Only one field can hold a @Parent annotation");
            Assert.isTrue((property.getType() == String.class ? 1 : 0) != 0, (String)"Parent ID property should be String");
            this.parentIdProperty = property;
            this.parentType = annotation.type();
        }
        if (property.isVersionProperty()) {
            Assert.isTrue((property.getType() == Long.class ? 1 : 0) != 0, (String)"Version property should be Long");
        }
    }
}

