/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractResultMapper
implements ResultsMapper {
    private EntityMapper entityMapper;

    public AbstractResultMapper(EntityMapper entityMapper) {
        Assert.notNull((Object)entityMapper, (String)"EntityMapper must not be null!");
        this.entityMapper = entityMapper;
    }

    public <T> T mapEntity(String source, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)source)) {
            return null;
        }
        try {
            return this.entityMapper.mapToObject(source, clazz);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to map source [ " + source + "] to class " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public EntityMapper getEntityMapper() {
        return this.entityMapper;
    }
}

