/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.elasticsearch.annotations.Score;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class SimpleElasticsearchPersistentProperty
extends AnnotationBasedPersistentProperty<ElasticsearchPersistentProperty>
implements ElasticsearchPersistentProperty {
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();
    private final boolean isScore = this.isAnnotationPresent(Score.class);

    public SimpleElasticsearchPersistentProperty(Property property, PersistentEntity<?, ElasticsearchPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        if (this.isScore && !Arrays.asList(Float.TYPE, Float.class).contains(this.getType())) {
            throw new MappingException(String.format("Score property %s must be either of type float or Float!", property.getName()));
        }
    }

    @Override
    public String getFieldName() {
        return this.getProperty().getName();
    }

    public boolean isIdProperty() {
        return super.isIdProperty() || SUPPORTED_ID_PROPERTY_NAMES.contains(this.getFieldName());
    }

    protected Association<ElasticsearchPersistentProperty> createAssociation() {
        return null;
    }

    @Override
    public boolean isScoreProperty() {
        return this.isScore;
    }

    public boolean isImmutable() {
        return false;
    }

    static {
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
        SUPPORTED_ID_PROPERTY_NAMES.add("documentId");
    }
}

