/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.config;

import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.config.ElasticsearchConfigurationSupport;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.lang.Nullable;

@Configuration
public abstract class AbstractReactiveElasticsearchConfiguration
extends ElasticsearchConfigurationSupport {
    public abstract ReactiveElasticsearchClient reactiveElasticsearchClient();

    @Bean
    public ReactiveElasticsearchOperations reactiveElasticsearchTemplate(ElasticsearchConverter elasticsearchConverter) {
        ReactiveElasticsearchTemplate template = new ReactiveElasticsearchTemplate(this.reactiveElasticsearchClient(), elasticsearchConverter);
        template.setIndicesOptions(this.indicesOptions());
        template.setRefreshPolicy(this.refreshPolicy());
        return template;
    }

    @Nullable
    protected WriteRequest.RefreshPolicy refreshPolicy() {
        return WriteRequest.RefreshPolicy.IMMEDIATE;
    }

    @Nullable
    protected IndicesOptions indicesOptions() {
        return IndicesOptions.strictExpandOpenAndForbidClosed();
    }
}

