/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.aggregation.impl;

import java.util.List;
import java.util.Optional;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.lang.Nullable;

public class AggregatedPageImpl<T>
extends PageImpl<T>
implements AggregatedPage<T> {
    @Nullable
    private Aggregations aggregations;
    @Nullable
    private String scrollId;
    private float maxScore;

    private static Pageable pageableOrUnpaged(@Nullable Pageable pageable) {
        return Optional.ofNullable(pageable).orElse(Pageable.unpaged());
    }

    public AggregatedPageImpl(List<T> content) {
        super(content);
    }

    public AggregatedPageImpl(List<T> content, float maxScore) {
        super(content);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, String scrollId) {
        super(content);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, String scrollId, float maxScore) {
        this(content, scrollId);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total);
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, float maxScore) {
        super(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, String scrollId) {
        super(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, String scrollId, float maxScore) {
        this(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total, scrollId);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, @Nullable Aggregations aggregations) {
        super(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total);
        this.aggregations = aggregations;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, @Nullable Aggregations aggregations, float maxScore) {
        this(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total, aggregations);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, @Nullable Aggregations aggregations, String scrollId) {
        this(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total, aggregations);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, @Nullable Aggregations aggregations, String scrollId, float maxScore) {
        this(content, AggregatedPageImpl.pageableOrUnpaged(pageable), total, aggregations, scrollId);
        this.maxScore = maxScore;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, SearchDocumentResponse response) {
        this(content, AggregatedPageImpl.pageableOrUnpaged(pageable), response.getTotalHits(), response.getAggregations(), response.getScrollId(), response.getMaxScore());
    }

    @Override
    public boolean hasAggregations() {
        return this.aggregations != null;
    }

    @Override
    @Nullable
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    @Nullable
    public Aggregation getAggregation(String name) {
        return this.aggregations == null ? null : this.aggregations.get(name);
    }

    @Override
    @Nullable
    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public float getMaxScore() {
        return this.maxScore;
    }
}

