/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.elasticsearch.search.fetch.subphase.highlight.AbstractHighlighterBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.springframework.data.elasticsearch.annotations.Highlight;
import org.springframework.data.elasticsearch.annotations.HighlightField;
import org.springframework.data.elasticsearch.annotations.HighlightParameters;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HighlightQueryBuilder {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public HighlightQueryBuilder(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public HighlightQuery getHighlightQuery(Highlight highlight, @Nullable Class<?> type) {
        Assert.notNull((Object)highlight, (String)"highlight must not be null");
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        this.addParameters(highlight.parameters(), (AbstractHighlighterBuilder<?>)highlightBuilder, type);
        for (HighlightField highlightField : highlight.fields()) {
            String mappedName = this.mapFieldName(highlightField.name(), type);
            HighlightBuilder.Field field = new HighlightBuilder.Field(mappedName);
            this.addParameters(highlightField.parameters(), (AbstractHighlighterBuilder<?>)field, type);
            highlightBuilder.field(field);
        }
        return new HighlightQuery(highlightBuilder);
    }

    private void addParameters(HighlightParameters parameters, AbstractHighlighterBuilder<?> builder, Class<?> type) {
        if (StringUtils.hasLength((String)parameters.boundaryChars())) {
            builder.boundaryChars(parameters.boundaryChars().toCharArray());
        }
        if (parameters.boundaryMaxScan() > -1) {
            builder.boundaryMaxScan(Integer.valueOf(parameters.boundaryMaxScan()));
        }
        if (StringUtils.hasLength((String)parameters.boundaryScanner())) {
            builder.boundaryScannerType(parameters.boundaryScanner());
        }
        if (StringUtils.hasLength((String)parameters.boundaryScannerLocale())) {
            builder.boundaryScannerLocale(parameters.boundaryScannerLocale());
        }
        if (parameters.forceSource()) {
            builder.forceSource(Boolean.valueOf(parameters.forceSource()));
        }
        if (StringUtils.hasLength((String)parameters.fragmenter())) {
            builder.fragmenter(parameters.fragmenter());
        }
        if (parameters.fragmentSize() > -1) {
            builder.fragmentSize(Integer.valueOf(parameters.fragmentSize()));
        }
        if (parameters.noMatchSize() > -1) {
            builder.noMatchSize(Integer.valueOf(parameters.noMatchSize()));
        }
        if (parameters.numberOfFragments() > -1) {
            builder.numOfFragments(Integer.valueOf(parameters.numberOfFragments()));
        }
        if (StringUtils.hasLength((String)parameters.order())) {
            builder.order(parameters.order());
        }
        if (parameters.phraseLimit() > -1) {
            builder.phraseLimit(Integer.valueOf(parameters.phraseLimit()));
        }
        if (parameters.preTags().length > 0) {
            builder.preTags(parameters.preTags());
        }
        if (parameters.postTags().length > 0) {
            builder.postTags(parameters.postTags());
        }
        if (!parameters.requireFieldMatch()) {
            builder.requireFieldMatch(Boolean.valueOf(parameters.requireFieldMatch()));
        }
        if (StringUtils.hasLength((String)parameters.type())) {
            builder.highlighterType(parameters.type());
        }
        if (builder instanceof HighlightBuilder) {
            HighlightBuilder highlightBuilder = (HighlightBuilder)builder;
            if (StringUtils.hasLength((String)parameters.encoder())) {
                highlightBuilder.encoder(parameters.encoder());
            }
            if (StringUtils.hasLength((String)parameters.tagsSchema())) {
                highlightBuilder.tagsSchema(parameters.tagsSchema());
            }
        }
        if (builder instanceof HighlightBuilder.Field) {
            HighlightBuilder.Field field = (HighlightBuilder.Field)builder;
            if (parameters.fragmentOffset() > -1) {
                field.fragmentOffset(parameters.fragmentOffset());
            }
            if (parameters.matchedFields().length > 0) {
                field.matchedFields(Arrays.stream(parameters.matchedFields()).map(fieldName -> this.mapFieldName((String)fieldName, type)).collect(Collectors.toList()).toArray(new String[0]));
            }
        }
    }

    private String mapFieldName(String fieldName, @Nullable Class<?> type) {
        ElasticsearchPersistentProperty persistentProperty;
        ElasticsearchPersistentEntity persistentEntity;
        if (type != null && (persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type)) != null && (persistentProperty = (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty(fieldName)) != null) {
            return persistentProperty.getFieldName();
        }
        return fieldName;
    }
}

