/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.springframework.data.elasticsearch.annotations.GeoShapeField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class GeoShapeMappingParameters {
    private static final String FIELD_PARAM_TYPE = "type";
    private static final String FIELD_PARAM_COERCE = "coerce";
    private static final String FIELD_PARAM_IGNORE_MALFORMED = "ignore_malformed";
    private static final String FIELD_PARAM_IGNORE_Z_VALUE = "ignore_z_value";
    private static final String FIELD_PARAM_ORIENTATION = "orientation";
    private static final String TYPE_VALUE_GEO_SHAPE = "geo_shape";
    private final boolean coerce;
    private final boolean ignoreMalformed;
    private final boolean ignoreZValue;
    private final GeoShapeField.Orientation orientation;

    public static GeoShapeMappingParameters from(@Nullable GeoShapeField annotation) {
        if (annotation == null) {
            return new GeoShapeMappingParameters(false, false, true, GeoShapeField.Orientation.ccw);
        }
        return new GeoShapeMappingParameters(annotation.coerce(), annotation.ignoreMalformed(), annotation.ignoreZValue(), annotation.orientation());
    }

    private GeoShapeMappingParameters(boolean coerce, boolean ignoreMalformed, boolean ignoreZValue, GeoShapeField.Orientation orientation) {
        this.coerce = coerce;
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
        this.orientation = orientation;
    }

    public void writeTypeAndParametersTo(XContentBuilder builder) throws IOException {
        Assert.notNull((Object)builder, (String)"builder must ot be null");
        if (this.coerce) {
            builder.field(FIELD_PARAM_COERCE, this.coerce);
        }
        if (this.ignoreMalformed) {
            builder.field(FIELD_PARAM_IGNORE_MALFORMED, this.ignoreMalformed);
        }
        if (!this.ignoreZValue) {
            builder.field(FIELD_PARAM_IGNORE_Z_VALUE, this.ignoreZValue);
        }
        if (this.orientation != GeoShapeField.Orientation.ccw) {
            builder.field(FIELD_PARAM_ORIENTATION, this.orientation.name());
        }
        builder.field(FIELD_PARAM_TYPE, TYPE_VALUE_GEO_SHAPE);
    }
}

