/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.clients.elasticsearch7.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.PhraseSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.SortBy;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.elasticsearch.core.suggest.response.TermSuggestion;
import org.springframework.data.elasticsearch.support.ScoreDoc;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchDocumentResponse {
    private static final Log LOGGER = LogFactory.getLog(SearchDocumentResponse.class);
    private final long totalHits;
    private final String totalHitsRelation;
    private final float maxScore;
    private final String scrollId;
    private final List<SearchDocument> searchDocuments;
    @Nullable
    private final AggregationsContainer<?> aggregations;
    @Nullable
    private final Suggest suggest;

    private SearchDocumentResponse(long totalHits, String totalHitsRelation, float maxScore, String scrollId, List<SearchDocument> searchDocuments, @Nullable Aggregations aggregations, @Nullable Suggest suggest) {
        this.totalHits = totalHits;
        this.totalHitsRelation = totalHitsRelation;
        this.maxScore = maxScore;
        this.scrollId = scrollId;
        this.searchDocuments = searchDocuments;
        this.aggregations = aggregations != null ? new ElasticsearchAggregations(aggregations) : null;
        this.suggest = suggest;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public String getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public List<SearchDocument> getSearchDocuments() {
        return this.searchDocuments;
    }

    @Nullable
    public AggregationsContainer<?> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public Suggest getSuggest() {
        return this.suggest;
    }

    public static <T> SearchDocumentResponse from(SearchResponse searchResponse, EntityCreator<T> entityCreator) {
        Assert.notNull((Object)searchResponse, (String)"searchResponse must not be null");
        SearchHits searchHits = searchResponse.getHits();
        String scrollId = searchResponse.getScrollId();
        Aggregations aggregations = searchResponse.getAggregations();
        org.elasticsearch.search.suggest.Suggest suggest = searchResponse.getSuggest();
        return SearchDocumentResponse.from(searchHits, scrollId, aggregations, suggest, entityCreator);
    }

    public static <T> SearchDocumentResponse from(SearchHits searchHits, @Nullable String scrollId, @Nullable Aggregations aggregations, @Nullable org.elasticsearch.search.suggest.Suggest suggestES, EntityCreator<T> entityCreator) {
        String totalHitsRelation;
        long totalHits;
        TotalHits responseTotalHits = searchHits.getTotalHits();
        if (responseTotalHits != null) {
            totalHits = responseTotalHits.value;
            totalHitsRelation = responseTotalHits.relation.name();
        } else {
            totalHits = searchHits.getHits().length;
            totalHitsRelation = "OFF";
        }
        float maxScore = searchHits.getMaxScore();
        ArrayList<SearchDocument> searchDocuments = new ArrayList<SearchDocument>();
        for (SearchHit searchHit : searchHits) {
            if (searchHit == null) continue;
            searchDocuments.add(DocumentAdapters.from(searchHit));
        }
        Suggest suggest = SearchDocumentResponse.suggestFrom(suggestES, entityCreator);
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, searchDocuments, aggregations, suggest);
    }

    @Nullable
    private static <T> Suggest suggestFrom(@Nullable org.elasticsearch.search.suggest.Suggest suggestES, EntityCreator<T> entityCreator) {
        if (suggestES == null) {
            return null;
        }
        ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>();
        for (Suggest.Suggestion suggestionES : suggestES) {
            ArrayList<TermSuggestion.Entry.Option> options;
            ArrayList<TermSuggestion.Entry> entries;
            if (suggestionES instanceof TermSuggestion) {
                TermSuggestion termSuggestionES = (TermSuggestion)suggestionES;
                entries = new ArrayList<TermSuggestion.Entry>();
                for (TermSuggestion.Entry entryES : termSuggestionES) {
                    options = new ArrayList<TermSuggestion.Entry.Option>();
                    for (TermSuggestion.Entry.Option optionES : entryES) {
                        options.add(new TermSuggestion.Entry.Option(SearchDocumentResponse.textToString(optionES.getText()), SearchDocumentResponse.textToString(optionES.getHighlighted()), optionES.getScore(), optionES.collateMatch(), optionES.getFreq()));
                    }
                    entries.add(new TermSuggestion.Entry(SearchDocumentResponse.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), (List<TermSuggestion.Entry.Option>)options));
                }
                suggestions.add(new org.springframework.data.elasticsearch.core.suggest.response.TermSuggestion(termSuggestionES.getName(), termSuggestionES.getSize(), entries, SearchDocumentResponse.suggestFrom(termSuggestionES.getSort())));
            }
            if (suggestionES instanceof org.elasticsearch.search.suggest.phrase.PhraseSuggestion) {
                org.elasticsearch.search.suggest.phrase.PhraseSuggestion phraseSuggestionES = (org.elasticsearch.search.suggest.phrase.PhraseSuggestion)suggestionES;
                entries = new ArrayList();
                for (TermSuggestion.Entry entryES : phraseSuggestionES) {
                    options = new ArrayList();
                    for (TermSuggestion.Entry.Option optionES : entryES) {
                        options.add((TermSuggestion.Entry.Option)((Object)new PhraseSuggestion.Entry.Option(SearchDocumentResponse.textToString(optionES.getText()), SearchDocumentResponse.textToString(optionES.getHighlighted()), optionES.getScore(), optionES.collateMatch())));
                    }
                    entries.add((TermSuggestion.Entry)((Object)new PhraseSuggestion.Entry(SearchDocumentResponse.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), options, entryES.getCutoffScore())));
                }
                suggestions.add(new PhraseSuggestion(phraseSuggestionES.getName(), phraseSuggestionES.getSize(), (List<PhraseSuggestion.Entry>)entries));
            }
            if (!(suggestionES instanceof CompletionSuggestion)) continue;
            CompletionSuggestion completionSuggestionES = (CompletionSuggestion)suggestionES;
            entries = new ArrayList();
            for (TermSuggestion.Entry entryES : completionSuggestionES) {
                options = new ArrayList();
                for (TermSuggestion.Entry.Option optionES : entryES) {
                    Object hitEntity;
                    SearchDocument searchDocument;
                    block13: {
                        searchDocument = optionES.getHit() != null ? DocumentAdapters.from(optionES.getHit()) : null;
                        hitEntity = null;
                        if (searchDocument != null) {
                            try {
                                hitEntity = ((CompletableFuture)entityCreator.apply(searchDocument)).get();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isWarnEnabled()) break block13;
                                LOGGER.warn((Object)"Error creating entity from SearchDocument");
                            }
                        }
                    }
                    options.add((TermSuggestion.Entry.Option)((Object)new CompletionSuggestion.Entry.Option<Object>(SearchDocumentResponse.textToString(optionES.getText()), SearchDocumentResponse.textToString(optionES.getHighlighted()), optionES.getScore(), optionES.collateMatch(), optionES.getContexts(), SearchDocumentResponse.scoreDocFrom(optionES.getDoc()), searchDocument, hitEntity)));
                }
                entries.add((TermSuggestion.Entry)((Object)new CompletionSuggestion.Entry(SearchDocumentResponse.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), options)));
            }
            suggestions.add(new org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion(completionSuggestionES.getName(), completionSuggestionES.getSize(), entries));
        }
        return new Suggest(suggestions, suggestES.hasScoreDocs());
    }

    private static SortBy suggestFrom(org.elasticsearch.search.suggest.SortBy sort) {
        return SortBy.valueOf(sort.name().toUpperCase());
    }

    @Nullable
    private static ScoreDoc scoreDocFrom(@Nullable org.apache.lucene.search.ScoreDoc scoreDoc) {
        if (scoreDoc == null) {
            return null;
        }
        return new ScoreDoc(scoreDoc.score, scoreDoc.doc, scoreDoc.shardIndex);
    }

    private static String textToString(@Nullable Text text) {
        return text != null ? text.string() : "";
    }

    @FunctionalInterface
    public static interface EntityCreator<T>
    extends Function<SearchDocument, CompletableFuture<T>> {
    }
}

