/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public class CriteriaQuery
extends BaseQuery {
    private Criteria criteria;

    public CriteriaQuery(Criteria criteria) {
        this(criteria, Pageable.unpaged());
    }

    public CriteriaQuery(Criteria criteria, Pageable pageable) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        this.criteria = criteria;
        this.pageable = pageable;
        this.addSort(pageable.getSort());
    }

    public static Query fromQuery(CriteriaQuery source) {
        return CriteriaQuery.fromQuery(source, new CriteriaQuery(source.criteria));
    }

    public static <T extends CriteriaQuery> T fromQuery(CriteriaQuery source, T destination) {
        Assert.notNull((Object)source, (String)"source must not be null");
        Assert.notNull(destination, (String)"destination must not be null");
        destination.addCriteria(source.getCriteria());
        if (source.getSort() != null) {
            destination.addSort(source.getSort());
        }
        return destination;
    }

    public final <T extends CriteriaQuery> T addCriteria(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Cannot add null criteria.");
        this.criteria.and(criteria);
        return (T)this;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }
}

