/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query.highlight;

import org.springframework.data.elasticsearch.core.query.highlight.HighlightCommonParameters;

public class HighlightFieldParameters
extends HighlightCommonParameters {
    private final int fragmentOffset;
    private final String[] matchedFields;

    private HighlightFieldParameters(HighlightFieldParametersBuilder builder) {
        super(builder);
        this.fragmentOffset = builder.fragmentOffset;
        this.matchedFields = builder.matchedFields;
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    public String[] getMatchedFields() {
        return this.matchedFields;
    }

    public static HighlightFieldParametersBuilder builder() {
        return new HighlightFieldParametersBuilder();
    }

    public static final class HighlightFieldParametersBuilder
    extends HighlightCommonParameters.HighlightCommonParametersBuilder<HighlightFieldParametersBuilder> {
        private int fragmentOffset = -1;
        private String[] matchedFields = new String[0];

        public HighlightFieldParametersBuilder withFragmentOffset(int fragmentOffset) {
            this.fragmentOffset = fragmentOffset;
            return this;
        }

        public HighlightFieldParametersBuilder withMatchedFields(String[] matchedFields) {
            this.matchedFields = matchedFields;
            return this;
        }

        @Override
        public HighlightFieldParameters build() {
            return new HighlightFieldParameters(this);
        }
    }
}

