/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.Collections;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsImpl;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.parser.ElasticsearchQueryCreator;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ElasticsearchPartQuery
extends AbstractElasticsearchRepositoryQuery {
    private final PartTree tree;
    private final ElasticsearchConverter elasticsearchConverter;
    private final MappingContext<?, ElasticsearchPersistentProperty> mappingContext;

    public ElasticsearchPartQuery(ElasticsearchQueryMethod method, ElasticsearchOperations elasticsearchOperations) {
        super(method, elasticsearchOperations);
        this.tree = new PartTree(this.queryMethod.getName(), this.queryMethod.getResultProcessor().getReturnedType().getDomainType());
        this.elasticsearchConverter = elasticsearchOperations.getElasticsearchConverter();
        this.mappingContext = this.elasticsearchConverter.getMappingContext();
    }

    @Override
    public boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    public Object execute(Object[] parameters) {
        Class clazz = this.queryMethod.getResultProcessor().getReturnedType().getDomainType();
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        CriteriaQuery query = this.createQuery(accessor);
        Assert.notNull((Object)query, (String)"unsupported query");
        this.elasticsearchConverter.updateQuery(query, clazz);
        if (this.queryMethod.hasAnnotatedHighlight()) {
            query.setHighlightQuery(this.queryMethod.getAnnotatedHighlightQuery());
        }
        IndexCoordinates index = this.elasticsearchOperations.getIndexCoordinatesFor(clazz);
        Object result = null;
        if (this.tree.isLimiting()) {
            query.setMaxResults(this.tree.getMaxResults());
        }
        if (this.tree.isDelete()) {
            result = this.countOrGetDocumentsForDelete(query, accessor);
            this.elasticsearchOperations.delete(query, clazz, index);
            this.elasticsearchOperations.indexOps(index).refresh();
        } else if (this.queryMethod.isPageQuery()) {
            query.setPageable(accessor.getPageable());
            SearchHits searchHits = this.elasticsearchOperations.search(query, clazz, index);
            result = this.queryMethod.isSearchPageMethod() ? SearchHitSupport.searchPageFor(searchHits, query.getPageable()) : SearchHitSupport.unwrapSearchHits(SearchHitSupport.searchPageFor(searchHits, query.getPageable()));
        } else if (this.queryMethod.isStreamQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                query.setPageable((Pageable)PageRequest.of((int)0, (int)500));
            } else {
                query.setPageable(accessor.getPageable());
            }
            result = StreamUtils.createStreamFromIterator(this.elasticsearchOperations.searchForStream(query, clazz, index));
        } else if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                int itemCount = (int)this.elasticsearchOperations.count(query, clazz, index);
                if (itemCount == 0) {
                    result = new SearchHitsImpl(0L, TotalHitsRelation.EQUAL_TO, Float.NaN, null, Collections.emptyList(), null, null);
                } else {
                    query.setPageable((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
                }
            } else {
                query.setPageable(accessor.getPageable());
            }
            if (result == null) {
                result = this.elasticsearchOperations.search(query, clazz, index);
            }
        } else {
            result = this.tree.isCountProjection() ? Long.valueOf(this.elasticsearchOperations.count(query, clazz, index)) : this.elasticsearchOperations.searchOne(query, clazz, index);
        }
        return this.queryMethod.isNotSearchHitMethod() && this.queryMethod.isNotSearchPageMethod() ? SearchHitSupport.unwrapSearchHits(result) : result;
    }

    @Nullable
    private Object countOrGetDocumentsForDelete(CriteriaQuery query, ParametersParameterAccessor accessor) {
        Object result = null;
        Class clazz = this.queryMethod.getEntityInformation().getJavaType();
        IndexCoordinates index = this.elasticsearchOperations.getIndexCoordinatesFor(clazz);
        if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                int itemCount = (int)this.elasticsearchOperations.count(query, clazz, index);
                query.setPageable((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
            } else {
                query.setPageable(accessor.getPageable());
            }
            result = this.elasticsearchOperations.search(query, clazz, index);
        }
        if (ClassUtils.isAssignable(Number.class, (Class)this.queryMethod.getReturnedObjectType())) {
            result = this.elasticsearchOperations.count(query, clazz, index);
        }
        return result;
    }

    public CriteriaQuery createQuery(ParametersParameterAccessor accessor) {
        return (CriteriaQuery)new ElasticsearchQueryCreator(this.tree, (ParameterAccessor)accessor, this.mappingContext).createQuery();
    }
}

