/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.springframework.data.elasticsearch.core.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.PhraseSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.SortBy;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.elasticsearch.core.suggest.response.TermSuggestion;
import org.springframework.data.elasticsearch.support.ScoreDoc;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchDocumentResponseBuilder {
    private static final Log LOGGER = LogFactory.getLog(SearchDocumentResponse.class);

    public static <T> SearchDocumentResponse from(SearchResponse searchResponse, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        Assert.notNull((Object)searchResponse, (String)"searchResponse must not be null");
        SearchHits searchHits = searchResponse.getHits();
        String scrollId = searchResponse.getScrollId();
        Aggregations aggregations = searchResponse.getAggregations();
        Suggest suggest = searchResponse.getSuggest();
        return SearchDocumentResponseBuilder.from(searchHits, scrollId, aggregations, suggest, entityCreator);
    }

    public static <T> SearchDocumentResponse from(SearchHits searchHits, @Nullable String scrollId, @Nullable Aggregations aggregations, @Nullable Suggest suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        String totalHitsRelation;
        long totalHits;
        TotalHits responseTotalHits = searchHits.getTotalHits();
        if (responseTotalHits != null) {
            totalHits = responseTotalHits.value;
            totalHitsRelation = responseTotalHits.relation.name();
        } else {
            totalHits = searchHits.getHits().length;
            totalHitsRelation = "OFF";
        }
        float maxScore = searchHits.getMaxScore();
        ArrayList<SearchDocument> searchDocuments = new ArrayList<SearchDocument>();
        for (SearchHit searchHit : searchHits) {
            if (searchHit == null) continue;
            searchDocuments.add(DocumentAdapters.from(searchHit));
        }
        ElasticsearchAggregations aggregationsContainer = aggregations != null ? new ElasticsearchAggregations(aggregations) : null;
        org.springframework.data.elasticsearch.core.suggest.response.Suggest suggest = SearchDocumentResponseBuilder.suggestFrom(suggestES, entityCreator);
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, searchDocuments, aggregationsContainer, suggest);
    }

    @Nullable
    private static <T> org.springframework.data.elasticsearch.core.suggest.response.Suggest suggestFrom(@Nullable Suggest suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        if (suggestES == null) {
            return null;
        }
        ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>();
        for (Suggest.Suggestion suggestionES : suggestES) {
            ArrayList<TermSuggestion.Entry.Option> options;
            ArrayList<TermSuggestion.Entry> entries;
            if (suggestionES instanceof TermSuggestion) {
                TermSuggestion termSuggestionES = (TermSuggestion)suggestionES;
                entries = new ArrayList<TermSuggestion.Entry>();
                for (TermSuggestion.Entry entryES : termSuggestionES) {
                    options = new ArrayList<TermSuggestion.Entry.Option>();
                    for (TermSuggestion.Entry.Option optionES : entryES) {
                        options.add(new TermSuggestion.Entry.Option(SearchDocumentResponseBuilder.textToString(optionES.getText()), SearchDocumentResponseBuilder.textToString(optionES.getHighlighted()), optionES.getScore(), optionES.collateMatch(), optionES.getFreq()));
                    }
                    entries.add(new TermSuggestion.Entry(SearchDocumentResponseBuilder.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), (List<TermSuggestion.Entry.Option>)options));
                }
                suggestions.add(new org.springframework.data.elasticsearch.core.suggest.response.TermSuggestion(termSuggestionES.getName(), termSuggestionES.getSize(), entries, SearchDocumentResponseBuilder.suggestFrom(termSuggestionES.getSort())));
            }
            if (suggestionES instanceof org.elasticsearch.search.suggest.phrase.PhraseSuggestion) {
                org.elasticsearch.search.suggest.phrase.PhraseSuggestion phraseSuggestionES = (org.elasticsearch.search.suggest.phrase.PhraseSuggestion)suggestionES;
                entries = new ArrayList();
                for (TermSuggestion.Entry entryES : phraseSuggestionES) {
                    options = new ArrayList();
                    for (TermSuggestion.Entry.Option optionES : entryES) {
                        options.add((TermSuggestion.Entry.Option)((Object)new PhraseSuggestion.Entry.Option(SearchDocumentResponseBuilder.textToString(optionES.getText()), SearchDocumentResponseBuilder.textToString(optionES.getHighlighted()), optionES.getScore(), optionES.collateMatch())));
                    }
                    entries.add((TermSuggestion.Entry)((Object)new PhraseSuggestion.Entry(SearchDocumentResponseBuilder.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), options, entryES.getCutoffScore())));
                }
                suggestions.add(new PhraseSuggestion(phraseSuggestionES.getName(), phraseSuggestionES.getSize(), (List<PhraseSuggestion.Entry>)entries));
            }
            if (!(suggestionES instanceof CompletionSuggestion)) continue;
            CompletionSuggestion completionSuggestionES = (CompletionSuggestion)suggestionES;
            entries = new ArrayList();
            for (TermSuggestion.Entry entryES : completionSuggestionES) {
                options = new ArrayList();
                for (TermSuggestion.Entry.Option optionES : entryES) {
                    Object hitEntity;
                    SearchDocument searchDocument;
                    block13: {
                        searchDocument = optionES.getHit() != null ? DocumentAdapters.from(optionES.getHit()) : null;
                        hitEntity = null;
                        if (searchDocument != null) {
                            try {
                                hitEntity = ((CompletableFuture)entityCreator.apply(searchDocument)).get();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isWarnEnabled()) break block13;
                                LOGGER.warn((Object)"Error creating entity from SearchDocument");
                            }
                        }
                    }
                    options.add((TermSuggestion.Entry.Option)((Object)new CompletionSuggestion.Entry.Option<Object>(SearchDocumentResponseBuilder.textToString(optionES.getText()), SearchDocumentResponseBuilder.textToString(optionES.getHighlighted()), optionES.getScore(), optionES.collateMatch(), optionES.getContexts(), SearchDocumentResponseBuilder.scoreDocFrom(optionES.getDoc()), searchDocument, hitEntity)));
                }
                entries.add((TermSuggestion.Entry)((Object)new CompletionSuggestion.Entry(SearchDocumentResponseBuilder.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), options)));
            }
            suggestions.add(new org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion(completionSuggestionES.getName(), completionSuggestionES.getSize(), entries));
        }
        return new org.springframework.data.elasticsearch.core.suggest.response.Suggest(suggestions, suggestES.hasScoreDocs());
    }

    private static SortBy suggestFrom(org.elasticsearch.search.suggest.SortBy sort) {
        return SortBy.valueOf(sort.name().toUpperCase());
    }

    @Nullable
    private static ScoreDoc scoreDocFrom(@Nullable org.apache.lucene.search.ScoreDoc scoreDoc) {
        if (scoreDoc == null) {
            return null;
        }
        return new ScoreDoc(scoreDoc.score, scoreDoc.doc, scoreDoc.shardIndex);
    }

    private static String textToString(@Nullable Text text) {
        return text != null ? text.string() : "";
    }
}

