/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AliasActionParameters {
    private final String[] indices;
    @Nullable
    private final String[] aliases;
    @Nullable
    private final Query filterQuery;
    @Nullable
    private final Class<?> filterQueryClass;
    @Nullable
    private final Boolean isHidden;
    @Nullable
    private final Boolean isWriteIndex;
    @Nullable
    private final String routing;
    @Nullable
    private final String indexRouting;
    @Nullable
    private final String searchRouting;

    private AliasActionParameters(String[] indices, @Nullable String[] aliases, @Nullable Boolean isHidden, @Nullable Boolean isWriteIndex, @Nullable String routing, @Nullable String indexRouting, @Nullable String searchRouting, @Nullable Query filterQuery, @Nullable Class<?> filterQueryClass) {
        this.indices = indices;
        this.aliases = aliases;
        this.isHidden = isHidden;
        this.isWriteIndex = isWriteIndex;
        this.routing = routing;
        this.indexRouting = indexRouting;
        this.searchRouting = searchRouting;
        this.filterQuery = filterQuery;
        this.filterQueryClass = filterQueryClass;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderForTemplate() {
        return new Builder().withIndices("");
    }

    public String[] getIndices() {
        return this.indices;
    }

    @Nullable
    public String[] getAliases() {
        return this.aliases;
    }

    @Nullable
    public Boolean getHidden() {
        return this.isHidden;
    }

    @Nullable
    public Boolean getWriteIndex() {
        return this.isWriteIndex;
    }

    @Nullable
    public String getRouting() {
        return this.routing;
    }

    @Nullable
    public String getIndexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public String getSearchRouting() {
        return this.searchRouting;
    }

    @Nullable
    public Query getFilterQuery() {
        return this.filterQuery;
    }

    @Nullable
    public Class<?> getFilterQueryClass() {
        return this.filterQueryClass;
    }

    public static final class Builder {
        @Nullable
        private String[] indices;
        @Nullable
        private String[] aliases;
        @Nullable
        private Query filterQuery;
        @Nullable
        private Class<?> filterQueryClass;
        @Nullable
        private Boolean isHidden;
        @Nullable
        private Boolean isWriteIndex;
        @Nullable
        private String routing;
        @Nullable
        private String indexRouting;
        @Nullable
        private String searchRouting;

        private Builder() {
        }

        public Builder withIndices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public Builder withAliases(String ... aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder withFilterQuery(Query filterQuery) {
            return this.withFilterQuery(filterQuery, null);
        }

        public Builder withFilterQuery(Query filterQuery, @Nullable Class<?> filterQueryClass) {
            this.filterQuery = filterQuery;
            this.filterQueryClass = filterQueryClass;
            return this;
        }

        public Builder withIsHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        public Builder withIsWriteIndex(Boolean isWriteIndex) {
            this.isWriteIndex = isWriteIndex;
            return this;
        }

        public Builder withRouting(String routing) {
            this.routing = routing;
            return this;
        }

        public Builder withIndexRouting(String indexRouting) {
            this.indexRouting = indexRouting;
            return this;
        }

        public Builder withSearchRouting(String searchRouting) {
            this.searchRouting = searchRouting;
            return this;
        }

        public AliasActionParameters build() {
            Assert.notNull((Object)this.indices, (String)"indices must be set");
            return new AliasActionParameters(this.indices, this.aliases, this.isHidden, this.isWriteIndex, this.routing, this.indexRouting, this.searchRouting, this.filterQuery, this.filterQueryClass);
        }
    }
}

