/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import org.springframework.data.elasticsearch.core.convert.AbstractRangePropertyValueConverter;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.mapping.PersistentProperty;

public class NumberRangePropertyValueConverter
extends AbstractRangePropertyValueConverter<Number> {
    public NumberRangePropertyValueConverter(PersistentProperty<?> property) {
        super(property);
    }

    @Override
    protected String format(Number number) {
        return String.valueOf(number);
    }

    @Override
    protected Number parse(String value) {
        Class<?> type = this.getGenericType();
        if (Integer.class.isAssignableFrom(type)) {
            return Integer.valueOf(value);
        }
        if (Float.class.isAssignableFrom(type)) {
            return Float.valueOf(value);
        }
        if (Long.class.isAssignableFrom(type)) {
            return Long.valueOf(value);
        }
        if (Double.class.isAssignableFrom(type)) {
            return Double.valueOf(value);
        }
        throw new ConversionException(String.format("Unable to convert value '%s' to %s for property '%s'", value, type.getTypeName(), this.getProperty().getName()));
    }
}

