/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GemfireTransactionCommitException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class GemfireTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean,
ResourceTransactionManager {
    private Cache cache;
    private boolean copyOnRead = true;

    public GemfireTransactionManager() {
    }

    public GemfireTransactionManager(Cache cache) {
        this.cache = cache;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cache, (String)"Cache property is required");
        this.cache.setCopyOnRead(this.copyOnRead);
    }

    protected Object doGetTransaction() throws TransactionException {
        CacheTransactionObject txObject = new CacheTransactionObject();
        CacheHolder cacheHolder = (CacheHolder)TransactionSynchronizationManager.getResource((Object)this.getCache());
        txObject.setHolder(cacheHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        CacheTransactionObject txObject = (CacheTransactionObject)transaction;
        return txObject.getHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        CacheTransactionObject txObject = (CacheTransactionObject)transaction;
        Cache cache = null;
        try {
            cache = this.getCache();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Acquired Cache [" + cache + "] for local Cache transaction"));
            }
            txObject.setHolder(new CacheHolder());
            cache.getCacheTransactionManager().begin();
            TransactionSynchronizationManager.bindResource((Object)cache, (Object)txObject.getHolder());
        }
        catch (IllegalStateException ex) {
            throw new CannotCreateTransactionException("An ongoing transaction already is already associated with the current thread; are there multiple transaction managers ?", (Throwable)ex);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Gemfire local transaction on Cache [" + this.cache + "]"));
        }
        try {
            this.cache.getCacheTransactionManager().commit();
        }
        catch (IllegalStateException ex) {
            throw new NoTransactionException("No transaction associated with the current thread; are there multiple transaction managers ?", (Throwable)ex);
        }
        catch (TransactionException ex) {
            throw new GemfireTransactionCommitException("Unexpected failure on commit of Cache local transaction", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Cache local transaction for [" + this.cache + "]"));
        }
        try {
            this.cache.getCacheTransactionManager().rollback();
        }
        catch (IllegalStateException ex) {
            throw new NoTransactionException("No transaction associated with the current thread; are there multiple transaction managers ?", (Throwable)ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        CacheTransactionObject txObject = (CacheTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Gemfire local transaction [" + txObject.getHolder() + "] rollback-only"));
        }
        txObject.getHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionSynchronizationManager.unbindResource((Object)this.cache);
    }

    protected final boolean useSavepointForNestedTransaction() {
        return false;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Object getResourceFactory() {
        return this.getCache();
    }

    public <K, V> void setRegion(Region<K, V> region) {
        Assert.notNull(region, (String)"non-null arguments are required");
        this.cache = (Cache)region.getRegionService();
    }

    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    public boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    private static class CacheHolder {
        private boolean rollbackOnly = false;

        private CacheHolder() {
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        public void setRollbackOnly() {
            this.rollbackOnly = true;
        }
    }

    private static class CacheTransactionObject {
        private CacheHolder cacheHolder;

        private CacheTransactionObject() {
        }

        public CacheHolder getHolder() {
            return this.cacheHolder;
        }

        public void setHolder(CacheHolder cacheHolder) {
            this.cacheHolder = cacheHolder;
        }
    }
}

