/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Properties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.data.gemfire.DeclarableSupport;

public class WiringDeclarableSupport
extends DeclarableSupport {
    private static final String BEAN_NAME_PROP = "bean-name";

    @Override
    protected void initInstance(Properties props) {
        BeanFactory bf = this.getBeanFactory();
        BeanConfigurerSupport configurer = new BeanConfigurerSupport();
        configurer.setBeanFactory(bf);
        final String beanName = props.getProperty(BEAN_NAME_PROP);
        if (beanName != null) {
            if (!bf.containsBean(beanName)) {
                throw new IllegalArgumentException("Cannot find bean named '" + beanName + "'");
            }
            configurer.setBeanWiringInfoResolver(new BeanWiringInfoResolver(){

                public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
                    return new BeanWiringInfo(beanName);
                }
            });
        }
        configurer.afterPropertiesSet();
        configurer.configureBean((Object)this);
        configurer.destroy();
    }
}

