/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.wan.AsyncEventQueueFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AsyncEventQueueParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return AsyncEventQueueFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setLazyInit(false);
        Element asyncEventListenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"async-event-listener");
        Object asyncEventListener = ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, asyncEventListenerElement, builder);
        String cacheName = !StringUtils.hasText((String)element.getAttribute("cache-ref")) ? "gemfireCache" : element.getAttribute("cache-ref");
        builder.addConstructorArgReference(cacheName);
        builder.addConstructorArgValue(asyncEventListener);
        ParsingUtils.setPropertyValue(element, builder, "batch-size");
        ParsingUtils.setPropertyValue(element, builder, "maximum-queue-memory");
        ParsingUtils.setPropertyValue(element, builder, "disk-store-ref");
        String diskStoreRef = element.getAttribute("disk-store-ref");
        if (StringUtils.hasText((String)diskStoreRef)) {
            builder.addDependsOn(diskStoreRef);
        }
        ParsingUtils.setPropertyValue(element, builder, "persistent");
        ParsingUtils.setPropertyValue(element, builder, "parallel");
        ParsingUtils.setPropertyValue(element, builder, "name");
        if (!StringUtils.hasText((String)element.getAttribute("name")) && element.getParentNode().getNodeName().endsWith("region")) {
            Element region = (Element)element.getParentNode();
            String regionName = StringUtils.hasText((String)region.getAttribute("name")) ? region.getAttribute("name") : region.getAttribute("id");
            int i = 0;
            String name = regionName + ".asyncEventQueue#" + i;
            while (parserContext.getRegistry().isBeanNameInUse(name)) {
                name = regionName + ".asyncEventQueue#" + ++i;
            }
            builder.addPropertyValue("name", (Object)name);
        }
    }
}

