/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.listener.adapter;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqQuery;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.listener.ContinuousQueryListener;
import org.springframework.data.gemfire.listener.GemfireListenerExecutionFailedException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ContinuousQueryListenerAdapter
implements ContinuousQueryListener {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleEvent";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object delegate;
    private String defaultListenerMethod = "handleEvent";
    private MethodInvoker invoker;

    public ContinuousQueryListenerAdapter() {
        this.setDelegate(this);
    }

    public ContinuousQueryListenerAdapter(Object delegate) {
        this.setDelegate(delegate);
    }

    public void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
        this.invoker = null;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
        this.invoker = null;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    @Override
    public void onEvent(CqEvent event) {
        try {
            if (this.delegate != this && this.delegate instanceof ContinuousQueryListener) {
                ((ContinuousQueryListener)this.delegate).onEvent(event);
                return;
            }
            String methodName = this.getListenerMethodName(event);
            if (this.invoker == null) {
                this.invoker = new MethodInvoker(this.delegate, methodName);
            }
            if (methodName == null) {
                throw new InvalidDataAccessApiUsageException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
            }
            this.invokeListenerMethod(event, methodName);
        }
        catch (Throwable th) {
            this.handleListenerException(th);
        }
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    protected String getListenerMethodName(CqEvent event) {
        return this.getDefaultListenerMethod();
    }

    protected void invokeListenerMethod(CqEvent event, String methodName) {
        try {
            this.invoker.invoke(event);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof DataAccessException) {
                throw (DataAccessException)targetEx;
            }
            throw new GemfireListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", targetEx);
        }
        catch (Throwable ex) {
            throw new GemfireListenerExecutionFailedException("Failed to invoke target method '" + methodName, ex);
        }
    }

    private class MethodInvoker {
        private final Object delegate;
        List<Method> methods;

        MethodInvoker(Object delegate, final String methodName) {
            this.delegate = delegate;
            Class<?> c = delegate.getClass();
            this.methods = new ArrayList<Method>();
            ReflectionUtils.doWithMethods(c, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    ReflectionUtils.makeAccessible((Method)method);
                    MethodInvoker.this.methods.add(method);
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    if (Modifier.isPublic(method.getModifiers()) && methodName.equals(method.getName())) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        int objects = 0;
                        int operations = 0;
                        if (parameterTypes.length > 0) {
                            for (Class<?> paramType : parameterTypes) {
                                if (Object.class.equals(paramType)) {
                                    if (++objects <= 2) continue;
                                    return false;
                                }
                                if (Operation.class.equals(paramType)) {
                                    if (++operations <= 2) continue;
                                    return false;
                                }
                                if (CqEvent.class.equals(paramType) || Throwable.class.equals(paramType) || byte[].class.equals(paramType) || CqQuery.class.equals(paramType)) continue;
                                return false;
                            }
                            return true;
                        }
                    }
                    return false;
                }
            });
            Assert.isTrue((!this.methods.isEmpty() ? 1 : 0) != 0, (String)("Cannot find a suitable method named [" + c.getName() + "#" + methodName + "] - is the method public and has the proper arguments?"));
        }

        void invoke(CqEvent event) throws InvocationTargetException, IllegalAccessException {
            for (Method m : this.methods) {
                Class<?>[] types = m.getParameterTypes();
                Object[] args = new Object[types.length];
                boolean value = false;
                boolean query = false;
                for (int i = 0; i < types.length; ++i) {
                    Class<?> paramType = types[i];
                    if (Object.class.equals(paramType)) {
                        args[i] = !value ? event.getKey() : event.getNewValue();
                        value = true;
                        continue;
                    }
                    if (Operation.class.equals(paramType)) {
                        args[i] = !query ? event.getBaseOperation() : event.getQueryOperation();
                        query = true;
                        continue;
                    }
                    if (CqEvent.class.equals(paramType)) {
                        args[i] = event;
                        continue;
                    }
                    if (Throwable.class.equals(paramType)) {
                        args[i] = event.getThrowable();
                        continue;
                    }
                    if (byte[].class.equals(paramType)) {
                        args[i] = event.getDeltaValue();
                        continue;
                    }
                    if (!CqQuery.class.equals(paramType)) continue;
                    args[i] = event.getCq();
                }
                m.invoke(this.delegate, args);
            }
        }
    }
}

