/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.IterableOfEntryToMapConverter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EntityRowMapper<T>
implements RowMapper<T> {
    private static final Converter<Iterable<?>, Map<?, ?>> ITERABLE_OF_ENTRY_TO_MAP_CONVERTER = new IterableOfEntryToMapConverter();
    private final RelationalPersistentEntity<T> entity;
    private final RelationalConverter converter;
    private final RelationalMappingContext context;
    private final DataAccessStrategy accessStrategy;
    private final RelationalPersistentProperty idProperty;

    public EntityRowMapper(RelationalPersistentEntity<T> entity, RelationalMappingContext context, RelationalConverter converter, DataAccessStrategy accessStrategy) {
        this.entity = entity;
        this.converter = converter;
        this.context = context;
        this.accessStrategy = accessStrategy;
        this.idProperty = (RelationalPersistentProperty)entity.getIdProperty();
    }

    public T mapRow(ResultSet resultSet, int rowNumber) {
        T result = this.createInstance(this.entity, resultSet, "");
        return this.entity.requiresPropertyPopulation() ? this.populateProperties(result, resultSet) : result;
    }

    private T populateProperties(T result, ResultSet resultSet) {
        PersistentPropertyAccessor<T> propertyAccessor = this.converter.getPropertyAccessor(this.entity, result);
        Object id = this.idProperty == null ? null : this.readFrom(resultSet, this.idProperty, "");
        PreferredConstructor persistenceConstructor = this.entity.getPersistenceConstructor();
        Iterator iterator = this.entity.iterator();
        while (iterator.hasNext()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)iterator.next();
            if (persistenceConstructor != null && persistenceConstructor.isConstructorParameter((PersistentProperty)property)) continue;
            if (property.isCollectionLike() && id != null) {
                propertyAccessor.setProperty((PersistentProperty)property, this.accessStrategy.findAllByProperty(id, property));
                continue;
            }
            if (property.isMap() && id != null) {
                Iterable allByProperty = this.accessStrategy.findAllByProperty(id, property);
                propertyAccessor.setProperty((PersistentProperty)property, ITERABLE_OF_ENTRY_TO_MAP_CONVERTER.convert(allByProperty));
                continue;
            }
            propertyAccessor.setProperty((PersistentProperty)property, this.readFrom(resultSet, property, ""));
        }
        return (T)propertyAccessor.getBean();
    }

    @Nullable
    private Object readFrom(ResultSet resultSet, RelationalPersistentProperty property, String prefix) {
        try {
            if (property.isEntity()) {
                return this.readEntityFrom(resultSet, property);
            }
            return this.converter.readValue(resultSet.getObject(prefix + property.getColumnName()), property.getTypeInformation());
        }
        catch (SQLException o_O) {
            throw new MappingException(String.format("Could not read property %s from result set!", property), (Throwable)o_O);
        }
    }

    @Nullable
    private <S> S readEntityFrom(ResultSet rs, PersistentProperty<?> property) {
        String prefix = property.getName() + "_";
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(property.getActualType());
        if (this.readFrom(rs, (RelationalPersistentProperty)entity.getRequiredIdProperty(), prefix) == null) {
            return null;
        }
        S instance = this.createInstance(entity, rs, prefix);
        PersistentPropertyAccessor<S> accessor = this.converter.getPropertyAccessor(entity, instance);
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            RelationalPersistentProperty p = (RelationalPersistentProperty)iterator.next();
            accessor.setProperty((PersistentProperty)p, this.readFrom(rs, p, prefix));
        }
        return instance;
    }

    private <S> S createInstance(RelationalPersistentEntity<S> entity, ResultSet rs, String prefix) {
        return (S)this.converter.createInstance(entity, parameter -> {
            String parameterName = parameter.getName();
            Assert.notNull((Object)parameterName, (String)"A constructor parameter name must not be null to be used with Spring Data JDBC");
            RelationalPersistentProperty property = (RelationalPersistentProperty)entity.getRequiredPersistentProperty(parameterName);
            return this.readFrom(rs, property, prefix);
        });
    }
}

