/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import org.springframework.data.mapping.PropertyPath;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RelationalPropertyPath {
    private final PropertyPath path;
    private final Class<?> rootType;

    RelationalPropertyPath(PropertyPath path) {
        Assert.notNull((Object)path, (String)"path must not be null if rootType is not set");
        this.path = path;
        this.rootType = null;
    }

    private RelationalPropertyPath(Class<?> type) {
        Assert.notNull(type, (String)"type must not be null if path is not set");
        this.path = null;
        this.rootType = type;
    }

    public static RelationalPropertyPath from(String source, Class<?> type) {
        if (StringUtils.isEmpty((Object)source)) {
            return new RelationalPropertyPath(type);
        }
        return new RelationalPropertyPath(PropertyPath.from((String)source, type));
    }

    public RelationalPropertyPath nested(String name) {
        return this.path == null ? new RelationalPropertyPath(PropertyPath.from((String)name, this.rootType)) : new RelationalPropertyPath(this.path.nested(name));
    }

    public PropertyPath getPath() {
        return this.path;
    }

    public String toDotPath() {
        return this.path == null ? "" : this.path.toDotPath();
    }
}

