/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class BasicRelationalPersistentProperty
extends AnnotationBasedPersistentProperty<RelationalPersistentProperty>
implements RelationalPersistentProperty {
    private static final Map<Class<?>, Class<?>> javaToDbType = new LinkedHashMap();
    private final RelationalMappingContext context;
    private final Lazy<Optional<String>> columnName;
    private final Lazy<Optional<String>> keyColumnName;

    public BasicRelationalPersistentProperty(Property property, PersistentEntity<?, RelationalPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, RelationalMappingContext context) {
        super(property, owner, simpleTypeHolder);
        Assert.notNull((Object)((Object)context), (String)"context must not be null.");
        this.context = context;
        this.columnName = Lazy.of(() -> Optional.ofNullable(this.findAnnotation(Column.class)).map(Column::value).filter(StringUtils::hasText));
        this.keyColumnName = Lazy.of(() -> Optional.ofNullable(this.findAnnotation(Column.class)).map(Column::keyColumn).filter(StringUtils::hasText));
    }

    protected Association<RelationalPersistentProperty> createAssociation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getColumnName() {
        return ((Optional)this.columnName.get()).orElseGet(() -> this.context.getNamingStrategy().getColumnName(this));
    }

    public Class getColumnType() {
        Class columnType = this.columnTypeIfEntity(this.getActualType());
        return columnType == null ? this.columnTypeForNonEntity(this.getActualType()) : columnType;
    }

    @Override
    public RelationalPersistentEntity<?> getOwner() {
        return (RelationalPersistentEntity)super.getOwner();
    }

    @Override
    public String getReverseColumnName() {
        return ((Optional)this.columnName.get()).orElseGet(() -> this.context.getNamingStrategy().getReverseColumnName(this));
    }

    @Override
    public String getKeyColumn() {
        if (this.isQualified()) {
            return ((Optional)this.keyColumnName.get()).orElseGet(() -> this.context.getNamingStrategy().getKeyColumn(this));
        }
        return null;
    }

    @Override
    public boolean isQualified() {
        return this.isMap() || this.isListLike();
    }

    @Override
    public boolean isOrdered() {
        return this.isListLike();
    }

    private boolean isListLike() {
        return this.isCollectionLike() && !Set.class.isAssignableFrom(this.getType());
    }

    @Nullable
    private Class columnTypeIfEntity(Class type) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(type);
        if (persistentEntity == null) {
            return null;
        }
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty == null) {
            return null;
        }
        return idProperty.getColumnType();
    }

    private Class columnTypeForNonEntity(Class type) {
        return javaToDbType.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).map(e -> (Class)e.getValue()).findFirst().orElseGet(() -> ClassUtils.resolvePrimitiveIfNecessary((Class)type));
    }

    static {
        javaToDbType.put(Enum.class, String.class);
        javaToDbType.put(ZonedDateTime.class, String.class);
        javaToDbType.put(Temporal.class, Date.class);
    }
}

