/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.FunctionCollector;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.Identifier;

public class CascadingDataAccessStrategy
implements DataAccessStrategy {
    private final List<DataAccessStrategy> strategies;

    public CascadingDataAccessStrategy(List<DataAccessStrategy> strategies) {
        this.strategies = new ArrayList<DataAccessStrategy>(strategies);
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Map<String, Object> additionalParameters) {
        return this.collect(das -> das.insert(instance, domainType, additionalParameters));
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier) {
        return this.collect(das -> das.insert(instance, domainType, identifier));
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        return this.collect(das -> das.update(instance, domainType));
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        this.collectVoid(das -> das.delete(id, domainType));
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.collectVoid(das -> das.delete(rootId, propertyPath));
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.collectVoid(das -> das.deleteAll(domainType));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.collectVoid(das -> das.deleteAll(propertyPath));
    }

    @Override
    public long count(Class<?> domainType) {
        return this.collect(das -> das.count(domainType));
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        return (T)this.collect(das -> das.findById(id, domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.collect(das -> das.findAll(domainType));
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return this.collect(das -> das.findAllById(ids, domainType));
    }

    @Override
    public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<RelationalPersistentProperty> path) {
        return this.collect(das -> das.findAllByPath(identifier, path));
    }

    @Override
    public <T> Iterable<T> findAllByProperty(Object rootId, RelationalPersistentProperty property) {
        return this.collect(das -> das.findAllByProperty(rootId, property));
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        return this.collect(das -> das.existsById(id, domainType));
    }

    private <T> T collect(Function<DataAccessStrategy, T> function) {
        return (T)this.strategies.stream().collect(new FunctionCollector<T>(function));
    }

    private void collectVoid(Consumer<DataAccessStrategy> consumer) {
        this.collect(das -> {
            consumer.accept((DataAccessStrategy)das);
            return null;
        });
    }
}

