/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.metamodel.Metamodel;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.data.jpa.provider.HibernateUtils;
import org.springframework.data.jpa.provider.JpaClassUtils;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.util.CloseableIterator;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public enum PersistenceProvider implements QueryExtractor,
ProxyIdAccessor
{
    HIBERNATE(Arrays.asList("org.hibernate.jpa.HibernateEntityManager", "org.hibernate.ejb.HibernateEntityManager"), Arrays.asList("org.hibernate.jpa.internal.metamodel.MetamodelImpl", "org.hibernate.ejb.metamodel.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return HibernateUtils.getHibernateQuery(query);
        }

        @Override
        public String getCountQueryPlaceholder() {
            return "*";
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return entity instanceof HibernateProxy;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }

        @Override
        public <T> Collection<T> potentiallyConvertEmptyCollection(Collection<T> collection) {
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new HibernateScrollableResultsIterator(jpaQuery);
        }
    }
    ,
    ECLIPSELINK(Collections.singleton("org.eclipse.persistence.jpa.JpaEntityManager"), Collections.singleton("org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return ((JpaQuery)query).getDatabaseQuery().getJPQLString();
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return null;
        }

        @Override
        public <T> Collection<T> potentiallyConvertEmptyCollection(Collection<T> collection) {
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new EclipseLinkScrollableResultsIterator<Object>(jpaQuery);
        }
    }
    ,
    OPEN_JPA(Collections.singleton("org.apache.openjpa.persistence.OpenJPAEntityManager"), Collections.singleton("org.apache.openjpa.persistence.meta.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return ((OpenJPAQuery)query).getQueryString();
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return entity instanceof PersistenceCapable;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return ((PersistenceCapable)entity).pcFetchObjectId();
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new OpenJpaResultStreamingIterator<Object>(jpaQuery);
        }
    }
    ,
    GENERIC_JPA(Collections.singleton("javax.persistence.EntityManager"), Collections.emptySet()){

        @Override
        public String extractQueryString(Query query) {
            return null;
        }

        @Override
        public boolean canExtractQuery() {
            return false;
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return null;
        }
    };

    private static ConcurrentReferenceHashMap<Class<?>, PersistenceProvider> CACHE;
    private final Iterable<String> entityManagerClassNames;
    private final Iterable<String> metamodelClassNames;

    private PersistenceProvider(Iterable<String> entityManagerClassNames, Iterable<String> metamodelClassNames) {
        this.entityManagerClassNames = entityManagerClassNames;
        this.metamodelClassNames = metamodelClassNames;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Class<?> entityManagerType = em.getDelegate().getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(entityManagerType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String entityManagerClassName : provider.entityManagerClassNames) {
                if (!JpaClassUtils.isEntityManagerOfType(em, entityManagerClassName)) continue;
                return PersistenceProvider.cacheAndReturn(entityManagerType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(entityManagerType, GENERIC_JPA);
    }

    public static PersistenceProvider fromMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null!");
        Class<?> metamodelType = metamodel.getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(metamodelType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String metamodelClassName : provider.metamodelClassNames) {
                if (!JpaClassUtils.isMetamodelOfType(metamodel, metamodelClassName)) continue;
                return PersistenceProvider.cacheAndReturn(metamodelType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(metamodelType, GENERIC_JPA);
    }

    private static PersistenceProvider cacheAndReturn(Class<?> type, PersistenceProvider provider) {
        CACHE.put(type, (Object)provider);
        return provider;
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    public String getCountQueryPlaceholder() {
        return "x";
    }

    public <T> Collection<T> potentiallyConvertEmptyCollection(Collection<T> collection) {
        return collection;
    }

    public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
        throw new UnsupportedOperationException("Streaming results is not implement for this PersistenceProvider: " + this.name());
    }

    static {
        CACHE = new ConcurrentReferenceHashMap();
    }

    private static class OpenJpaResultStreamingIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> iterator;

        public OpenJpaResultStreamingIterator(Query jpaQuery) {
            OpenJPAQuery kq = OpenJPAPersistence.cast((Query)jpaQuery);
            JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
            fetch.setFetchBatchSize(20);
            fetch.setResultSetType(ResultSetType.SCROLL_SENSITIVE);
            fetch.setFetchDirection(FetchDirection.FORWARD);
            fetch.setLRSSizeAlgorithm(LRSSizeAlgorithm.LAST);
            List resultList = kq.getResultList();
            this.iterator = resultList.iterator();
        }

        public boolean hasNext() {
            return this.iterator == null ? false : this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }

        public void close() {
            if (this.iterator != null) {
                OpenJPAPersistence.close(this.iterator);
            }
        }
    }

    private static class EclipseLinkScrollableResultsIterator<T>
    implements CloseableIterator<T> {
        private final ScrollableCursor scrollableCursor;

        public EclipseLinkScrollableResultsIterator(Query jpaQuery) {
            jpaQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            this.scrollableCursor = (ScrollableCursor)jpaQuery.getSingleResult();
        }

        public boolean hasNext() {
            return this.scrollableCursor == null ? false : this.scrollableCursor.hasNext();
        }

        public T next() {
            return (T)this.scrollableCursor.next();
        }

        public void close() {
            if (this.scrollableCursor != null) {
                this.scrollableCursor.close();
            }
        }
    }

    private static class HibernateScrollableResultsIterator
    implements CloseableIterator<Object> {
        private static final Method READ_ONLY_METHOD = ClassUtils.getMethod(org.hibernate.Query.class, (String)"setReadOnly", (Class[])new Class[]{Boolean.TYPE});
        private static final Method SCROLL_METHOD = ClassUtils.getMethod(READ_ONLY_METHOD.getReturnType(), (String)"scroll", (Class[])new Class[]{ScrollMode.class});
        private final ScrollableResults scrollableResults;

        public HibernateScrollableResultsIterator(Query jpaQuery) {
            org.hibernate.Query query = (org.hibernate.Query)jpaQuery.unwrap(org.hibernate.Query.class);
            boolean isReadOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            if (READ_ONLY_METHOD.getReturnType().equals(org.hibernate.Query.class)) {
                this.scrollableResults = query.setReadOnly(isReadOnly).scroll(ScrollMode.FORWARD_ONLY);
            } else {
                Object intermediate = ReflectionUtils.invokeMethod((Method)READ_ONLY_METHOD, (Object)jpaQuery, (Object[])new Object[]{isReadOnly});
                this.scrollableResults = (ScrollableResults)ReflectionUtils.invokeMethod((Method)SCROLL_METHOD, (Object)intermediate, (Object[])new Object[]{ScrollMode.FORWARD_ONLY});
            }
        }

        public Object next() {
            Object[] row = this.scrollableResults.get();
            return row.length == 1 ? row[0] : row;
        }

        public boolean hasNext() {
            return this.scrollableResults == null ? false : this.scrollableResults.next();
        }

        public void close() {
            if (this.scrollableResults != null) {
                this.scrollableResults.close();
            }
        }
    }

    static interface Constants {
        public static final String GENERIC_JPA_ENTITY_MANAGER_INTERFACE = "javax.persistence.EntityManager";
        public static final String OPENJPA_ENTITY_MANAGER_INTERFACE = "org.apache.openjpa.persistence.OpenJPAEntityManager";
        public static final String ECLIPSELINK_ENTITY_MANAGER_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManager";
        public static final String HIBERNATE_ENTITY_MANAGER_INTERFACE = "org.hibernate.ejb.HibernateEntityManager";
        public static final String HIBERNATE43_ENTITY_MANAGER_INTERFACE = "org.hibernate.jpa.HibernateEntityManager";
        public static final String HIBERNATE_JPA_METAMODEL_TYPE = "org.hibernate.ejb.metamodel.MetamodelImpl";
        public static final String HIBERNATE43_JPA_METAMODEL_TYPE = "org.hibernate.jpa.internal.metamodel.MetamodelImpl";
        public static final String ECLIPSELINK_JPA_METAMODEL_TYPE = "org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl";
        public static final String OPENJPA_JPA_METAMODEL_TYPE = "org.apache.openjpa.persistence.meta.MetamodelImpl";
    }
}

