/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.repository.core.support.ExampleMatcherAccessor;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryByExamplePredicateBuilder {
    private static final Set<Attribute.PersistentAttributeType> ASSOCIATION_TYPES = new HashSet<Attribute.PersistentAttributeType>(Arrays.asList(Attribute.PersistentAttributeType.MANY_TO_MANY, Attribute.PersistentAttributeType.MANY_TO_ONE, Attribute.PersistentAttributeType.ONE_TO_MANY, Attribute.PersistentAttributeType.ONE_TO_ONE));

    public static <T> Predicate getPredicate(Root<T> root, CriteriaBuilder cb, Example<T> example) {
        return QueryByExamplePredicateBuilder.getPredicate(root, cb, example, EscapeCharacter.DEFAULT);
    }

    public static <T> Predicate getPredicate(Root<T> root, CriteriaBuilder cb, Example<T> example, EscapeCharacter escapeCharacter) {
        Assert.notNull(root, (String)"Root must not be null!");
        Assert.notNull((Object)cb, (String)"CriteriaBuilder must not be null!");
        Assert.notNull(example, (String)"Example must not be null!");
        ExampleMatcher matcher = example.getMatcher();
        List<Predicate> predicates = QueryByExamplePredicateBuilder.getPredicates("", cb, root, root.getModel(), example.getProbe(), example.getProbeType(), new ExampleMatcherAccessor(matcher), new PathNode("root", null, example.getProbe()), escapeCharacter);
        if (predicates.isEmpty()) {
            return cb.isTrue(cb.literal((Object)true));
        }
        if (predicates.size() == 1) {
            return predicates.iterator().next();
        }
        Predicate[] array = predicates.toArray(new Predicate[0]);
        return matcher.isAllMatching() ? cb.and(array) : cb.or(array);
    }

    static List<Predicate> getPredicates(String path, CriteriaBuilder cb, Path<?> from, ManagedType<?> type, Object value, Class<?> probeType, ExampleMatcherAccessor exampleAccessor, PathNode currentNode, EscapeCharacter escapeCharacter) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        DirectFieldAccessFallbackBeanWrapper beanWrapper = new DirectFieldAccessFallbackBeanWrapper(value);
        for (SingularAttribute attribute : type.getSingularAttributes()) {
            String currentPath = !StringUtils.hasText((String)path) ? attribute.getName() : path + "." + attribute.getName();
            if (exampleAccessor.isIgnoredPath(currentPath)) continue;
            Object attributeValue = exampleAccessor.getValueTransformerForPath(currentPath).convert(beanWrapper.getPropertyValue(attribute.getName()));
            if (attributeValue == null) {
                if (!exampleAccessor.getNullHandler().equals((Object)ExampleMatcher.NullHandler.INCLUDE)) continue;
                predicates.add(cb.isNull((Expression)from.get(attribute)));
                continue;
            }
            if (attribute.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.EMBEDDED)) {
                predicates.addAll(QueryByExamplePredicateBuilder.getPredicates(currentPath, cb, from.get(attribute.getName()), (ManagedType)attribute.getType(), attributeValue, probeType, exampleAccessor, currentNode, escapeCharacter));
                continue;
            }
            if (QueryByExamplePredicateBuilder.isAssociation(attribute)) {
                if (!(from instanceof From)) {
                    throw new JpaSystemException((RuntimeException)new IllegalArgumentException(String.format("Unexpected path type for %s. Found %s where From.class was expected.", currentPath, from)));
                }
                PathNode node = currentNode.add(attribute.getName(), attributeValue);
                if (node.spansCycle()) {
                    throw new InvalidDataAccessApiUsageException(String.format("Path '%s' from root %s must not span a cyclic property reference!\r\n%s", currentPath, ClassUtils.getShortName(probeType), node));
                }
                predicates.addAll(QueryByExamplePredicateBuilder.getPredicates(currentPath, cb, ((From)from).join(attribute.getName()), (ManagedType)attribute.getType(), attributeValue, probeType, exampleAccessor, node, escapeCharacter));
                continue;
            }
            if (attribute.getJavaType().equals(String.class)) {
                Path expression = from.get(attribute);
                if (exampleAccessor.isIgnoreCaseForPath(currentPath)) {
                    expression = cb.lower((Expression)expression);
                    attributeValue = attributeValue.toString().toLowerCase();
                }
                switch (exampleAccessor.getStringMatcherForPath(currentPath)) {
                    case DEFAULT: 
                    case EXACT: {
                        predicates.add(cb.equal((Expression)expression, attributeValue));
                        break;
                    }
                    case CONTAINING: {
                        predicates.add(cb.like((Expression)expression, "%" + escapeCharacter.escape(attributeValue.toString()) + "%", escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    case STARTING: {
                        predicates.add(cb.like((Expression)expression, escapeCharacter.escape(attributeValue.toString()) + "%", escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    case ENDING: {
                        predicates.add(cb.like((Expression)expression, "%" + escapeCharacter.escape(attributeValue.toString()), escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported StringMatcher " + exampleAccessor.getStringMatcherForPath(currentPath));
                    }
                }
                continue;
            }
            predicates.add(cb.equal((Expression)from.get(attribute), attributeValue));
        }
        return predicates;
    }

    private static boolean isAssociation(Attribute<?, ?> attribute) {
        return ASSOCIATION_TYPES.contains(attribute.getPersistentAttributeType());
    }

    private static class PathNode {
        String name;
        PathNode parent;
        List<PathNode> siblings = new ArrayList<PathNode>();
        Object value;

        public PathNode(String edge, PathNode parent, Object value) {
            this.name = edge;
            this.parent = parent;
            this.value = value;
        }

        PathNode add(String attribute, Object value) {
            PathNode node = new PathNode(attribute, this, value);
            this.siblings.add(node);
            return node;
        }

        boolean spansCycle() {
            if (this.value == null) {
                return false;
            }
            String identityHex = ObjectUtils.getIdentityHexString((Object)this.value);
            PathNode tmp = this.parent;
            while (tmp != null) {
                if (ObjectUtils.getIdentityHexString((Object)tmp.value).equals(identityHex)) {
                    return true;
                }
                tmp = tmp.parent;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.parent != null) {
                sb.append(this.parent.toString());
                sb.append(" -");
                sb.append(this.name);
                sb.append("-> ");
            }
            sb.append("[{ ");
            sb.append(ObjectUtils.nullSafeToString((Object)this.value));
            sb.append(" }]");
            return sb.toString();
        }
    }
}

