/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public class ParameterBinder {
    static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to use provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final JpaParameters parameters;
    private final Iterable<QueryParameterSetter> parameterSetters;

    public ParameterBinder(JpaParameters parameters, Iterable<QueryParameterSetter> parameterSetters) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        Assert.notNull(parameterSetters, (String)"Parameter setters must not be null!");
        this.parameters = parameters;
        this.parameterSetters = parameterSetters;
    }

    public <T extends Query> T bind(T jpaQuery, Object[] values) {
        this.parameterSetters.forEach(it -> it.setParameter(jpaQuery, values));
        return jpaQuery;
    }

    Query bindAndPrepare(Query query, Object[] values) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.parameters, values);
        Query result = this.bind(query, values);
        if (!this.parameters.hasPageableParameter() || accessor.getPageable().isUnpaged()) {
            return result;
        }
        result.setFirstResult((int)accessor.getPageable().getOffset());
        result.setMaxResults(accessor.getPageable().getPageSize());
        return result;
    }
}

