/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JpaRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private EntityManager entityManager;
    private EscapeCharacter escapeCharacter = EscapeCharacter.of('\\');

    public JpaRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = EscapeCharacter.of(escapeCharacter);
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        Assert.state((this.entityManager != null ? 1 : 0) != 0, (String)"EntityManager must not be null!");
        return this.createRepositoryFactory(this.entityManager);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        JpaRepositoryFactory jpaRepositoryFactory = new JpaRepositoryFactory(entityManager);
        jpaRepositoryFactory.setEscapeCharacter(this.escapeCharacter);
        return jpaRepositoryFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.entityManager != null ? 1 : 0) != 0, (String)"EntityManager must not be null!");
        super.afterPropertiesSet();
    }
}

