/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;

public final class JSqlParserUtils {
    private JSqlParserUtils() {
    }

    public static Function getJSqlCount(List<String> countFields, boolean distinct) {
        List countColumns = countFields.stream().map(Column::new).collect(Collectors.toList());
        ExpressionList countExpression = new ExpressionList(countColumns);
        return new Function().withName("count").withParameters(countExpression).withDistinct(distinct);
    }

    public static Function getJSqlLower(String column) {
        List<Column> expressions = Collections.singletonList(new Column(column));
        ExpressionList lowerParamExpression = new ExpressionList(expressions);
        return new Function().withName("lower").withParameters(lowerParamExpression);
    }
}

