/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import jakarta.persistence.EntityManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.TypedParameterValue;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.lang.Nullable;

class HibernateJpaParametersParameterAccessor
extends JpaParametersParameterAccessor {
    private final BasicTypeRegistry typeHelper;

    HibernateJpaParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values, EntityManager em) {
        super(parameters, values);
        this.typeHelper = ((SessionFactoryImplementor)em.getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)).getTypeConfiguration().getBasicTypeRegistry();
    }

    @Nullable
    public Object getValue(Parameter parameter) {
        Object value = super.getValue(parameter.getIndex());
        if (value != null) {
            return value;
        }
        BasicType type = this.typeHelper.getRegisteredType(parameter.getType());
        if (type == null) {
            return null;
        }
        return new TypedParameterValue((BindableType)type, null);
    }

    @Override
    protected Object potentiallyUnwrap(Object parameterValue) {
        Object object;
        if (parameterValue instanceof TypedParameterValue) {
            TypedParameterValue typedParameterValue = (TypedParameterValue)parameterValue;
            object = typedParameterValue.getValue();
        } else {
            object = parameterValue;
        }
        return object;
    }
}

