/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.List;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaKeysetScrollQueryCreator;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.ScrollDelegate;
import org.springframework.data.jpa.repository.support.JpaMetamodelEntityInformation;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;

public class PartTreeJpaQuery
extends AbstractJpaQuery {
    private final PartTree tree;
    private final JpaParameters parameters;
    private final QueryPreparer query;
    private final QueryPreparer countQuery;
    private final EntityManager em;
    private final EscapeCharacter escape;
    private final JpaMetamodelEntityInformation<?, Object> entityInformation;

    PartTreeJpaQuery(JpaQueryMethod method, EntityManager em) {
        this(method, em, EscapeCharacter.DEFAULT);
    }

    PartTreeJpaQuery(JpaQueryMethod method, EntityManager em, EscapeCharacter escape) {
        super(method, em);
        this.em = em;
        this.escape = escape;
        this.parameters = method.getParameters();
        Class domainClass = method.getEntityInformation().getJavaType();
        PersistenceUnitUtil persistenceUnitUtil = em.getEntityManagerFactory().getPersistenceUnitUtil();
        this.entityInformation = new JpaMetamodelEntityInformation(domainClass, em.getMetamodel(), persistenceUnitUtil);
        boolean recreationRequired = this.parameters.hasDynamicProjection() || this.parameters.potentiallySortsDynamically() || method.isScrollQuery();
        try {
            this.tree = new PartTree(method.getName(), domainClass);
            PartTreeJpaQuery.validate(this.tree, this.parameters, method.toString());
            this.countQuery = new CountQueryPreparer(recreationRequired);
            this.query = this.tree.isCountProjection() ? this.countQuery : new QueryPreparer(recreationRequired);
        }
        catch (Exception o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s; %s", new Object[]{method, o_O.getMessage()}), o_O);
        }
    }

    @Override
    public Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        return this.query.createQuery(accessor);
    }

    public TypedQuery<Long> doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        return (TypedQuery)this.countQuery.createQuery(accessor);
    }

    @Override
    protected JpaQueryExecution getExecution() {
        if (this.getQueryMethod().isScrollQuery()) {
            return new JpaQueryExecution.ScrollExecution(this.tree.getSort(), new ScrollDelegate(this.entityInformation));
        }
        if (this.tree.isDelete()) {
            return new JpaQueryExecution.DeleteExecution(this.em);
        }
        if (this.tree.isExistsProjection()) {
            return new JpaQueryExecution.ExistsExecution();
        }
        return super.getExecution();
    }

    private static void validate(PartTree tree, JpaParameters parameters, String methodName) {
        int argCount = 0;
        Iterable parts = () -> tree.stream().flatMap(Streamable::stream).iterator();
        for (Part part : parts) {
            int numberOfArguments = part.getNumberOfArguments();
            for (int i = 0; i < numberOfArguments; ++i) {
                PartTreeJpaQuery.throwExceptionOnArgumentMismatch(methodName, part, parameters, argCount);
                ++argCount;
            }
        }
    }

    private static void throwExceptionOnArgumentMismatch(String methodName, Part part, JpaParameters parameters, int index) {
        Part.Type type = part.getType();
        String property = part.getProperty().toDotPath();
        if (!((JpaParameters)parameters.getBindableParameters()).hasParameterAt(index)) {
            throw new IllegalStateException(String.format("Method %s expects at least %d arguments but only found %d; This leaves an operator of type %s for property %s unbound", methodName, index + 1, index, type.name(), property));
        }
        JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)parameters.getBindableParameter(index);
        if (PartTreeJpaQuery.expectsCollection(type) && !PartTreeJpaQuery.parameterIsCollectionLike(parameter)) {
            throw new IllegalStateException(PartTreeJpaQuery.wrongParameterTypeMessage(methodName, property, type, "Collection", parameter));
        }
        if (!PartTreeJpaQuery.expectsCollection(type) && !PartTreeJpaQuery.parameterIsScalarLike(parameter)) {
            throw new IllegalStateException(PartTreeJpaQuery.wrongParameterTypeMessage(methodName, property, type, "scalar", parameter));
        }
    }

    private static String wrongParameterTypeMessage(String methodName, String property, Part.Type operatorType, String expectedArgumentType, JpaParameters.JpaParameter parameter) {
        return String.format("Operator %s on %s requires a %s argument, found %s in method %s", operatorType.name(), property, expectedArgumentType, parameter.getType(), methodName);
    }

    private static boolean parameterIsCollectionLike(JpaParameters.JpaParameter parameter) {
        return Iterable.class.isAssignableFrom(parameter.getType()) || parameter.getType().isArray();
    }

    private static boolean parameterIsScalarLike(JpaParameters.JpaParameter parameter) {
        return !Iterable.class.isAssignableFrom(parameter.getType());
    }

    private static boolean expectsCollection(Part.Type type) {
        return type == Part.Type.IN || type == Part.Type.NOT_IN;
    }

    private class CountQueryPreparer
    extends QueryPreparer {
        CountQueryPreparer(boolean recreateQueries) {
            super(recreateQueries);
        }

        @Override
        protected JpaQueryCreator createCreator(@Nullable JpaParametersParameterAccessor accessor) {
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor != null ? new ParameterMetadataProvider(builder, accessor, PartTreeJpaQuery.this.escape) : new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters, PartTreeJpaQuery.this.escape);
            return new JpaCountQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.getQueryMethod().getResultProcessor().getReturnedType(), builder, provider);
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query, JpaParametersParameterAccessor accessor, QueryParameterSetter.QueryMetadataCache metadataCache) {
            QueryParameterSetter.QueryMetadata metadata = metadataCache.getMetadata("countquery", (Query)query);
            return binder.bind(query, metadata, accessor);
        }
    }

    private class QueryPreparer {
        @Nullable
        private final CriteriaQuery<?> cachedCriteriaQuery;
        @Nullable
        private final ParameterBinder cachedParameterBinder;
        private final QueryParameterSetter.QueryMetadataCache metadataCache = new QueryParameterSetter.QueryMetadataCache();

        QueryPreparer(boolean recreateQueries) {
            JpaQueryCreator creator = this.createCreator(null);
            if (recreateQueries) {
                this.cachedCriteriaQuery = null;
                this.cachedParameterBinder = null;
            } else {
                this.cachedCriteriaQuery = (CriteriaQuery)creator.createQuery();
                this.cachedParameterBinder = this.getBinder(creator.getParameterExpressions());
            }
        }

        public Query createQuery(JpaParametersParameterAccessor accessor) {
            CriteriaQuery criteriaQuery = this.cachedCriteriaQuery;
            ParameterBinder parameterBinder = this.cachedParameterBinder;
            if (this.cachedCriteriaQuery == null || accessor.hasBindableNullValue()) {
                JpaQueryCreator creator = this.createCreator(accessor);
                criteriaQuery = (CriteriaQuery)creator.createQuery(this.getDynamicSort(accessor));
                List<ParameterMetadataProvider.ParameterMetadata<?>> expressions = creator.getParameterExpressions();
                parameterBinder = this.getBinder(expressions);
            }
            if (parameterBinder == null) {
                throw new IllegalStateException("ParameterBinder is null");
            }
            TypedQuery<?> query = this.createQuery(criteriaQuery);
            ScrollPosition scrollPosition = accessor.getParameters().hasScrollPositionParameter() ? accessor.getScrollPosition() : null;
            return this.restrictMaxResultsIfNecessary(this.invokeBinding(parameterBinder, query, accessor, this.metadataCache), scrollPosition);
        }

        private Query restrictMaxResultsIfNecessary(Query query, @Nullable ScrollPosition scrollPosition) {
            if (PartTreeJpaQuery.this.tree.isLimiting()) {
                if (scrollPosition instanceof OffsetScrollPosition) {
                    OffsetScrollPosition offset = (OffsetScrollPosition)scrollPosition;
                    query.setFirstResult(Math.toIntExact(offset.getOffset()));
                }
                if (query.getMaxResults() != Integer.MAX_VALUE && query.getMaxResults() > PartTreeJpaQuery.this.tree.getMaxResults() && query.getFirstResult() > 0) {
                    query.setFirstResult(query.getFirstResult() - (query.getMaxResults() - PartTreeJpaQuery.this.tree.getMaxResults()));
                }
                query.setMaxResults(PartTreeJpaQuery.this.tree.getMaxResults().intValue());
            }
            if (PartTreeJpaQuery.this.tree.isExistsProjection()) {
                query.setMaxResults(1);
            }
            return query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TypedQuery<?> createQuery(CriteriaQuery<?> criteriaQuery) {
            if (this.cachedCriteriaQuery != null) {
                CriteriaQuery<?> criteriaQuery2 = this.cachedCriteriaQuery;
                synchronized (criteriaQuery2) {
                    return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
                }
            }
            return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
        }

        protected JpaQueryCreator createCreator(@Nullable JpaParametersParameterAccessor accessor) {
            ScrollPosition scrollPosition;
            ReturnedType returnedType;
            ParameterMetadataProvider provider;
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ResultProcessor processor = PartTreeJpaQuery.this.getQueryMethod().getResultProcessor();
            if (accessor != null) {
                provider = new ParameterMetadataProvider(builder, accessor, PartTreeJpaQuery.this.escape);
                returnedType = processor.withDynamicProjection((ParameterAccessor)accessor).getReturnedType();
            } else {
                provider = new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters, PartTreeJpaQuery.this.escape);
                returnedType = processor.getReturnedType();
            }
            if (accessor != null && (scrollPosition = accessor.getScrollPosition()) instanceof KeysetScrollPosition) {
                KeysetScrollPosition keyset = (KeysetScrollPosition)scrollPosition;
                return new JpaKeysetScrollQueryCreator(PartTreeJpaQuery.this.tree, returnedType, builder, provider, PartTreeJpaQuery.this.entityInformation, keyset);
            }
            return new JpaQueryCreator(PartTreeJpaQuery.this.tree, returnedType, builder, provider);
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query, JpaParametersParameterAccessor accessor, QueryParameterSetter.QueryMetadataCache metadataCache) {
            QueryParameterSetter.QueryMetadata metadata = metadataCache.getMetadata("query", (Query)query);
            return binder.bindAndPrepare((Query)query, metadata, accessor);
        }

        private ParameterBinder getBinder(List<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
            return ParameterBinderFactory.createCriteriaBinder(PartTreeJpaQuery.this.parameters, expressions);
        }

        private Sort getDynamicSort(JpaParametersParameterAccessor accessor) {
            return PartTreeJpaQuery.this.parameters.potentiallySortsDynamically() ? accessor.getSort() : Sort.unsorted();
        }
    }
}

