/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import com.querydsl.collections.AbstractCollQuery;
import com.querydsl.collections.CollQuery;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.support.KeyValueQuerydslUtils;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class QuerydslKeyValueRepository<T, ID extends Serializable>
extends SimpleKeyValueRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private static final EntityPathResolver DEFAULT_ENTITY_PATH_RESOLVER = SimpleEntityPathResolver.INSTANCE;
    private final EntityPath<T> path;
    private final PathBuilder<T> builder;

    public QuerydslKeyValueRepository(EntityInformation<T, ID> entityInformation, KeyValueOperations operations) {
        this(entityInformation, operations, DEFAULT_ENTITY_PATH_RESOLVER);
    }

    public QuerydslKeyValueRepository(EntityInformation<T, ID> entityInformation, KeyValueOperations operations, EntityPathResolver resolver) {
        super(entityInformation, operations);
        Assert.notNull((Object)resolver, (String)"EntityPathResolver must not be null!");
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.prepareQuery(predicate).fetchOne();
    }

    public Iterable<T> findAll(Predicate predicate) {
        return this.prepareQuery(predicate).fetchResults().getResults();
    }

    public Iterable<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        AbstractCollQuery<T, ?> query = this.prepareQuery(predicate);
        query.orderBy(orders);
        return query.fetchResults().getResults();
    }

    public Iterable<T> findAll(Predicate predicate, Sort sort) {
        return this.findAll(predicate, KeyValueQuerydslUtils.toOrderSpecifier(sort, this.builder));
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        AbstractCollQuery<T, ?> query = this.prepareQuery(predicate);
        if (pageable != null) {
            query.offset((long)pageable.getOffset());
            query.limit((long)pageable.getPageSize());
            if (pageable.getSort() != null) {
                query.orderBy(KeyValueQuerydslUtils.toOrderSpecifier(pageable.getSort(), this.builder));
            }
        }
        return new PageImpl(query.fetchResults().getResults(), pageable, this.count(predicate));
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        if (ObjectUtils.isEmpty((Object[])orders)) {
            return this.findAll();
        }
        AbstractCollQuery<T, ?> query = this.prepareQuery(null);
        query.orderBy(orders);
        return query.fetchResults().getResults();
    }

    public long count(Predicate predicate) {
        return this.prepareQuery(predicate).fetchCount();
    }

    @Override
    public boolean exists(Predicate predicate) {
        return this.count(predicate) > 0L;
    }

    protected AbstractCollQuery<T, ?> prepareQuery(Predicate predicate) {
        CollQuery query = new CollQuery();
        query.from(this.builder, this.findAll());
        return predicate != null ? (CollQuery)query.where(predicate) : query;
    }
}

