/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.query;

import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class KeyValueQuery<T> {
    private Sort sort = Sort.unsorted();
    private long offset = -1L;
    private int rows = -1;
    @Nullable
    private final T criteria;

    public KeyValueQuery() {
        this(null);
    }

    public KeyValueQuery(@Nullable T criteria) {
        this.criteria = criteria;
    }

    public KeyValueQuery(@Nullable T criteria, Sort sort) {
        this.criteria = criteria;
        this.setSort(sort);
    }

    public KeyValueQuery(Sort sort) {
        this();
        this.setSort(sort);
    }

    @Nullable
    public T getCriteria() {
        return this.criteria;
    }

    public Sort getSort() {
        return this.sort;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getRows() {
        return this.rows;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setSort(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        this.sort = sort;
    }

    public KeyValueQuery<T> orderBy(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        this.sort = this.sort.isSorted() ? this.sort.and(sort) : sort;
        return this;
    }

    public KeyValueQuery<T> skip(long offset) {
        this.setOffset(offset);
        return this;
    }

    public KeyValueQuery<T> limit(int rows) {
        this.setRows(rows);
        return this;
    }
}

