/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteResult;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.util.ReflectionUtils;

final class ReflectiveWriteResultInvoker {
    private static final Method GET_ERROR_METHOD = ReflectionUtils.findMethod(WriteResult.class, (String)"getError");
    private static final Method WAS_ACKNOWLEDGED_METHOD = ReflectionUtils.findMethod(WriteResult.class, (String)"wasAcknowledged");

    private ReflectiveWriteResultInvoker() {
    }

    public static String getError(WriteResult writeResult) {
        if (MongoClientVersion.isMongo3Driver()) {
            return null;
        }
        return (String)ReflectionUtils.invokeMethod((Method)GET_ERROR_METHOD, (Object)writeResult);
    }

    public static boolean wasAcknowledged(WriteResult writeResult) {
        return MongoClientVersion.isMongo3Driver() ? (Boolean)ReflectionUtils.invokeMethod((Method)WAS_ACKNOWLEDGED_METHOD, (Object)writeResult) : true;
    }
}

