/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mongodb.core.mapreduce.MapReduceCounts;
import org.springframework.data.mongodb.core.mapreduce.MapReduceTiming;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    private final DBObject rawResults;
    private final String outputCollection;
    private final MapReduceTiming mapReduceTiming;
    private final MapReduceCounts mapReduceCounts;

    public MapReduceResults(List<T> mappedResults, DBObject rawResults) {
        Assert.notNull(mappedResults);
        Assert.notNull((Object)rawResults);
        this.mappedResults = mappedResults;
        this.rawResults = rawResults;
        this.mapReduceTiming = this.parseTiming(rawResults);
        this.mapReduceCounts = this.parseCounts(rawResults);
        this.outputCollection = this.parseOutputCollection(rawResults);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public MapReduceTiming getTiming() {
        return this.mapReduceTiming;
    }

    public MapReduceCounts getCounts() {
        return this.mapReduceCounts;
    }

    public String getOutputCollection() {
        return this.outputCollection;
    }

    public DBObject getRawResults() {
        return this.rawResults;
    }

    private MapReduceTiming parseTiming(DBObject rawResults) {
        DBObject timing = (DBObject)rawResults.get("timing");
        if (timing == null) {
            return new MapReduceTiming(-1L, -1L, -1L);
        }
        if (timing.get("mapTime") != null && timing.get("emitLoop") != null && timing.get("total") != null) {
            return new MapReduceTiming(this.getAsLong(timing, "mapTime"), this.getAsLong(timing, "emitLoop"), this.getAsLong(timing, "total"));
        }
        return new MapReduceTiming(-1L, -1L, -1L);
    }

    private Long getAsLong(DBObject source, String key) {
        Object raw = source.get(key);
        return raw instanceof Long ? (Long)raw : (long)((Integer)raw).intValue();
    }

    private MapReduceCounts parseCounts(DBObject rawResults) {
        DBObject counts = (DBObject)rawResults.get("counts");
        if (counts == null) {
            return MapReduceCounts.NONE;
        }
        if (counts.get("input") != null && counts.get("emit") != null && counts.get("output") != null) {
            return new MapReduceCounts(this.getAsLong(counts, "input"), this.getAsLong(counts, "emit"), this.getAsLong(counts, "output"));
        }
        return MapReduceCounts.NONE;
    }

    private String parseOutputCollection(DBObject rawResults) {
        Object resultField = rawResults.get("result");
        if (resultField == null) {
            return null;
        }
        return resultField instanceof DBObject ? ((DBObject)resultField).get("collection").toString() : resultField.toString();
    }
}

