/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.convert.GeoConverters;
import org.springframework.data.mongodb.core.convert.MongoConverters;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.lang.Nullable;

public class MongoCustomConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Object> STORE_CONVERTERS;

    MongoCustomConversions() {
        this(Collections.emptyList());
    }

    public MongoCustomConversions(List<?> converters) {
        super(STORE_CONVERSIONS, converters);
    }

    static {
        ArrayList<? extends Object> converters = new ArrayList<Object>();
        converters.add((Object)CustomToStringConverter.INSTANCE);
        converters.addAll(MongoConverters.getConvertersToRegister());
        converters.addAll(JodaTimeConverters.getConvertersToRegister());
        converters.addAll(GeoConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)MongoSimpleTypes.HOLDER, STORE_CONVERTERS);
    }

    @WritingConverter
    private static enum CustomToStringConverter implements GenericConverter
    {
        INSTANCE;


        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            GenericConverter.ConvertiblePair localeToString = new GenericConverter.ConvertiblePair(Locale.class, String.class);
            GenericConverter.ConvertiblePair booleanToString = new GenericConverter.ConvertiblePair(Character.class, String.class);
            return new HashSet<GenericConverter.ConvertiblePair>(Arrays.asList(localeToString, booleanToString));
        }

        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source != null ? source.toString() : null;
        }
    }
}

