/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoParsingUtils;
import org.springframework.data.mongodb.core.MongoClientFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoClientParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        String id = element.getAttribute("id");
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MongoClientFactoryBean.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)"port", (String)"port");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)"host", (String)"host");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)"credentials", (String)"credentials");
        MongoParsingUtils.parseMongoClientOptions(element, builder);
        MongoParsingUtils.parseReplicaSet(element, builder);
        String defaultedId = StringUtils.hasText((String)id) ? id : "mongoClient";
        parserContext.pushContainingComponent(new CompositeComponentDefinition("Mongo", source));
        BeanComponentDefinition mongoComponent = helper.getComponent(builder, defaultedId);
        parserContext.registerBeanComponent(mongoComponent);
        BeanComponentDefinition serverAddressPropertyEditor = helper.getComponent(MongoParsingUtils.getServerAddressPropertyEditorBuilder());
        parserContext.registerBeanComponent(serverAddressPropertyEditor);
        BeanComponentDefinition writeConcernEditor = helper.getComponent(MongoParsingUtils.getWriteConcernPropertyEditorBuilder());
        parserContext.registerBeanComponent(writeConcernEditor);
        BeanComponentDefinition readPreferenceEditor = helper.getComponent(MongoParsingUtils.getReadPreferencePropertyEditorBuilder());
        parserContext.registerBeanComponent(readPreferenceEditor);
        BeanComponentDefinition credentialsEditor = helper.getComponent(MongoParsingUtils.getMongoCredentialPropertyEditor());
        parserContext.registerBeanComponent(credentialsEditor);
        parserContext.popAndRegisterContainingComponent();
        return mongoComponent.getBeanDefinition();
    }
}

