/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import lombok.NonNull;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.ReactiveUpdateOperation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

class ReactiveUpdateOperationSupport
implements ReactiveUpdateOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final ReactiveMongoTemplate template;

    @Override
    public <T> ReactiveUpdateOperation.ReactiveUpdate<T> update(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveUpdateSupport<T>(this.template, domainType, ALL_QUERY, null, null, null, null, null, domainType);
    }

    public ReactiveUpdateOperationSupport(@NonNull ReactiveMongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is marked non-null but is null");
        }
        this.template = template;
    }

    static class ReactiveUpdateSupport<T>
    implements ReactiveUpdateOperation.ReactiveUpdate<T>,
    ReactiveUpdateOperation.UpdateWithCollection<T>,
    ReactiveUpdateOperation.UpdateWithQuery<T>,
    ReactiveUpdateOperation.TerminatingUpdate<T>,
    ReactiveUpdateOperation.FindAndReplaceWithOptions<T>,
    ReactiveUpdateOperation.FindAndReplaceWithProjection<T>,
    ReactiveUpdateOperation.TerminatingFindAndReplace<T> {
        @NonNull
        private final ReactiveMongoTemplate template;
        @NonNull
        private final Class<?> domainType;
        private final Query query;
        private final Update update;
        @Nullable
        private final String collection;
        @Nullable
        private final FindAndModifyOptions findAndModifyOptions;
        @Nullable
        private final FindAndReplaceOptions findAndReplaceOptions;
        @Nullable
        private final Object replacement;
        @NonNull
        private final Class<T> targetType;

        @Override
        public ReactiveUpdateOperation.TerminatingUpdate<T> apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public ReactiveUpdateOperation.UpdateWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, this.update, collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public Mono<UpdateResult> first() {
            return this.doUpdate(false, false);
        }

        @Override
        public Mono<UpdateResult> upsert() {
            return this.doUpdate(true, true);
        }

        @Override
        public Mono<T> findAndModify() {
            String collectionName = this.getCollectionName();
            return this.template.findAndModify(this.query, this.update, this.findAndModifyOptions != null ? this.findAndModifyOptions : FindAndModifyOptions.none(), this.targetType, collectionName);
        }

        @Override
        public Mono<T> findAndReplace() {
            return this.template.findAndReplace(this.query, this.replacement, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : FindAndReplaceOptions.none(), this.domainType, this.getCollectionName(), this.targetType);
        }

        @Override
        public ReactiveUpdateOperation.UpdateWithUpdate<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public Mono<UpdateResult> all() {
            return this.doUpdate(true, false);
        }

        @Override
        public ReactiveUpdateOperation.TerminatingFindAndModify<T> withOptions(FindAndModifyOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, options, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public ReactiveUpdateOperation.FindAndReplaceWithProjection<T> replaceWith(T replacement) {
            Assert.notNull(replacement, (String)"Replacement must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, replacement, this.targetType);
        }

        @Override
        public ReactiveUpdateOperation.FindAndReplaceWithProjection<T> withOptions(FindAndReplaceOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, options, this.replacement, this.targetType);
        }

        @Override
        public <R> ReactiveUpdateOperation.FindAndReplaceWithOptions<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"ResultType must not be null!");
            return new ReactiveUpdateSupport<R>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, resultType);
        }

        private Mono<UpdateResult> doUpdate(boolean multi, boolean upsert) {
            return this.template.doUpdate(this.getCollectionName(), this.query, this.update, this.domainType, upsert, multi);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }

        public ReactiveUpdateSupport(@NonNull ReactiveMongoTemplate template, @NonNull Class<?> domainType, Query query, Update update, @Nullable String collection, @Nullable FindAndModifyOptions findAndModifyOptions, @Nullable FindAndReplaceOptions findAndReplaceOptions, @Nullable Object replacement, @NonNull Class<T> targetType) {
            if (template == null) {
                throw new IllegalArgumentException("template is marked non-null but is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is marked non-null but is null");
            }
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is marked non-null but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.update = update;
            this.collection = collection;
            this.findAndModifyOptions = findAndModifyOptions;
            this.findAndReplaceOptions = findAndReplaceOptions;
            this.replacement = replacement;
            this.targetType = targetType;
        }
    }
}

