/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.gridfs.AsyncInputStream;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSBuckets;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadStream;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.gridfs.AntPath;
import org.springframework.data.mongodb.gridfs.BinaryStreamAdapters;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsOperationsSupport;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsOperations;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveGridFsTemplate
extends GridFsOperationsSupport
implements ReactiveGridFsOperations {
    private final ReactiveMongoDatabaseFactory dbFactory;
    private final DataBufferFactory dataBufferFactory;
    @Nullable
    private final String bucket;

    public ReactiveGridFsTemplate(ReactiveMongoDatabaseFactory dbFactory, MongoConverter converter) {
        this(dbFactory, converter, null);
    }

    public ReactiveGridFsTemplate(ReactiveMongoDatabaseFactory dbFactory, MongoConverter converter, @Nullable String bucket) {
        this((DataBufferFactory)new DefaultDataBufferFactory(), dbFactory, converter, bucket);
    }

    public ReactiveGridFsTemplate(DataBufferFactory dataBufferFactory, ReactiveMongoDatabaseFactory dbFactory, MongoConverter converter, @Nullable String bucket) {
        super(converter);
        Assert.notNull((Object)dataBufferFactory, (String)"DataBufferFactory must not be null!");
        Assert.notNull((Object)dbFactory, (String)"ReactiveMongoDatabaseFactory must not be null!");
        this.dataBufferFactory = dataBufferFactory;
        this.dbFactory = dbFactory;
        this.bucket = bucket;
    }

    @Override
    public Mono<ObjectId> store(AsyncInputStream content, @Nullable String filename, @Nullable String contentType, @Nullable Object metadata) {
        return this.store(content, filename, contentType, this.toDocument(metadata));
    }

    @Override
    public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable String filename, @Nullable String contentType, @Nullable Object metadata) {
        return this.store(content, filename, contentType, this.toDocument(metadata));
    }

    @Override
    public Mono<ObjectId> store(AsyncInputStream content, @Nullable String filename, @Nullable String contentType, @Nullable Document metadata) {
        Assert.notNull((Object)content, (String)"InputStream must not be null!");
        return Mono.from((Publisher)this.getGridFs().uploadFromStream(filename, content, this.computeUploadOptionsFor(contentType, metadata)));
    }

    @Override
    public Mono<ObjectId> store(Publisher<DataBuffer> content, @Nullable String filename, @Nullable String contentType, @Nullable Document metadata) {
        Assert.notNull(content, (String)"Content must not be null!");
        return BinaryStreamAdapters.toAsyncInputStream(content).flatMap(it -> this.store((AsyncInputStream)it, filename, contentType, metadata));
    }

    @Override
    public Flux<GridFSFile> find(Query query) {
        return Flux.from((Publisher)this.prepareQuery(query));
    }

    @Override
    public Mono<GridFSFile> findOne(Query query) {
        return Flux.from((Publisher)this.prepareQuery(query).limit(2)).collectList().flatMap(it -> {
            if (it.isEmpty()) {
                return Mono.empty();
            }
            if (it.size() > 1) {
                return Mono.error((Throwable)new IncorrectResultSizeDataAccessException("Query " + SerializationUtils.serializeToJsonSafely(query) + " returned non unique result.", 1));
            }
            return Mono.just(it.get(0));
        });
    }

    @Override
    public Mono<GridFSFile> findFirst(Query query) {
        return Flux.from((Publisher)this.prepareQuery(query).limit(1)).next();
    }

    @Override
    public Mono<Void> delete(Query query) {
        return this.find(query).flatMap(it -> this.getGridFs().delete(it.getId())).then();
    }

    @Override
    public Mono<ReactiveGridFsResource> getResource(String location) {
        Assert.notNull((Object)location, (String)"Filename must not be null!");
        return this.findOne(Query.query(GridFsCriteria.whereFilename().is(location))).flatMap(this::getResource).defaultIfEmpty((Object)ReactiveGridFsResource.absent(location));
    }

    @Override
    public Mono<ReactiveGridFsResource> getResource(GridFSFile file) {
        Assert.notNull((Object)file, (String)"GridFSFile must not be null!");
        return Mono.fromSupplier(() -> new ReactiveGridFsResource(file, chunkSize -> {
            GridFSDownloadStream stream = this.getGridFs().openDownloadStream(file.getId());
            return BinaryStreamAdapters.toPublisher((AsyncInputStream)stream, this.dataBufferFactory, chunkSize);
        }));
    }

    @Override
    public Flux<ReactiveGridFsResource> getResources(String locationPattern) {
        if (!StringUtils.hasText((String)locationPattern)) {
            return Flux.empty();
        }
        AntPath path = new AntPath(locationPattern);
        if (path.isPattern()) {
            Flux<GridFSFile> files = this.find(Query.query(GridFsCriteria.whereFilename().regex(path.toRegex())));
            return files.flatMap(this::getResource);
        }
        return this.getResource(locationPattern).flux();
    }

    protected GridFSFindPublisher prepareQuery(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Document queryObject = this.getMappedQuery(query.getQueryObject());
        Document sortObject = this.getMappedQuery(query.getSortObject());
        GridFSFindPublisher publisherToUse = this.getGridFs().find((Bson)queryObject).sort((Bson)sortObject);
        Integer cursorBatchSize = query.getMeta().getCursorBatchSize();
        if (cursorBatchSize != null) {
            publisherToUse = publisherToUse.batchSize(cursorBatchSize.intValue());
        }
        return publisherToUse;
    }

    protected GridFSBucket getGridFs() {
        MongoDatabase db = this.dbFactory.getMongoDatabase();
        return this.bucket == null ? GridFSBuckets.create((MongoDatabase)db) : GridFSBuckets.create((MongoDatabase)db, (String)this.bucket);
    }
}

