/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.AggregationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ClassUtils;

public class StringBasedAggregation
extends AbstractMongoQuery {
    private final MongoOperations mongoOperations;
    private final MongoConverter mongoConverter;
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public StringBasedAggregation(MongoQueryMethod method, MongoOperations mongoOperations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations, expressionParser, evaluationContextProvider);
        this.mongoOperations = mongoOperations;
        this.mongoConverter = mongoOperations.getConverter();
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    protected Object doExecute(MongoQueryMethod method, ResultProcessor resultProcessor, ConvertingParameterAccessor accessor, Class<?> typeToRead) {
        Class<?> sourceType = method.getDomainClass();
        Class targetType = typeToRead;
        List<AggregationOperation> pipeline = this.computePipeline(method, accessor);
        AggregationUtils.appendSortIfPresent(pipeline, accessor, typeToRead);
        AggregationUtils.appendLimitAndOffsetIfPresent(pipeline, accessor);
        boolean isSimpleReturnType = this.isSimpleReturnType(typeToRead);
        boolean isRawAggregationResult = ClassUtils.isAssignable(AggregationResults.class, typeToRead);
        if (isSimpleReturnType) {
            targetType = Document.class;
        } else if (isRawAggregationResult) {
            targetType = method.getReturnType().getRequiredActualType().getRequiredComponentType().getType();
        }
        AggregationOptions options = this.computeOptions(method, accessor);
        TypedAggregation aggregation = new TypedAggregation(sourceType, pipeline, options);
        AggregationResults result = this.mongoOperations.aggregate(aggregation, targetType);
        if (isRawAggregationResult) {
            return result;
        }
        if (method.isCollectionQuery()) {
            if (isSimpleReturnType) {
                return result.getMappedResults().stream().map(it -> AggregationUtils.extractSimpleTypeResult((Document)it, typeToRead, this.mongoConverter)).collect(Collectors.toList());
            }
            return result.getMappedResults();
        }
        Object uniqueResult = result.getUniqueMappedResult();
        return isSimpleReturnType ? AggregationUtils.extractSimpleTypeResult((Document)uniqueResult, typeToRead, this.mongoConverter) : uniqueResult;
    }

    private boolean isSimpleReturnType(Class<?> targetType) {
        return MongoSimpleTypes.HOLDER.isSimpleType(targetType);
    }

    List<AggregationOperation> computePipeline(MongoQueryMethod method, ConvertingParameterAccessor accessor) {
        return AggregationUtils.computePipeline(method, accessor, this.expressionParser, this.evaluationContextProvider);
    }

    private AggregationOptions computeOptions(MongoQueryMethod method, ConvertingParameterAccessor accessor) {
        AggregationOptions.Builder builder = Aggregation.newAggregationOptions();
        AggregationUtils.applyCollation(builder, method.getAnnotatedCollation(), accessor, method.getParameters(), this.expressionParser, this.evaluationContextProvider);
        AggregationUtils.applyMeta(builder, method);
        return builder.build();
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("No query support for aggregation");
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

