/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Collections;
import java.util.Iterator;
import org.springframework.data.mongodb.core.spel.LiteralNode;
import org.springframework.data.mongodb.core.spel.MethodReferenceNode;
import org.springframework.data.mongodb.core.spel.NotOperatorNode;
import org.springframework.data.mongodb.core.spel.OperatorNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.MethodReference;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.OperatorNot;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ExpressionNode
implements Iterable<ExpressionNode> {
    private static final Iterator<ExpressionNode> EMPTY_ITERATOR = Collections.emptySet().iterator();
    private final SpelNode node;
    private final ExpressionState state;

    protected ExpressionNode(SpelNode node, ExpressionState state) {
        Assert.notNull((Object)node, (String)"SpelNode must not be null!");
        Assert.notNull((Object)state, (String)"ExpressionState must not be null!");
        this.node = node;
        this.state = state;
    }

    public static ExpressionNode from(SpelNode node, ExpressionState state) {
        if (node instanceof Operator) {
            return new OperatorNode((Operator)node, state);
        }
        if (node instanceof MethodReference) {
            return new MethodReferenceNode((MethodReference)node, state);
        }
        if (node instanceof Literal) {
            return new LiteralNode((Literal)node, state);
        }
        if (node instanceof OperatorNot) {
            return new NotOperatorNode((OperatorNot)node, state);
        }
        return new ExpressionNode(node, state);
    }

    public String getName() {
        return this.node.toStringAST();
    }

    public boolean isOfType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be empty!");
        return type.isAssignableFrom(this.node.getClass());
    }

    boolean isOfSameTypeAs(@Nullable ExpressionNode node) {
        return node == null ? false : this.node.getClass().equals(node.node.getClass());
    }

    public boolean isMathematicalOperation() {
        return false;
    }

    public boolean isLogicalOperator() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    @Nullable
    public Object getValue() {
        return this.node.getValue(this.state);
    }

    public boolean hasChildren() {
        return this.node.getChildCount() != 0;
    }

    public ExpressionNode getChild(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Index must be greater or equal to zero!");
        return ExpressionNode.from(this.node.getChild(index), this.state);
    }

    public boolean hasfirstChildNotOfType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return this.hasChildren() && !this.node.getChild(0).getClass().equals(type);
    }

    protected ExpressionNode from(SpelNode node) {
        return ExpressionNode.from(node, this.state);
    }

    @Override
    public Iterator<ExpressionNode> iterator() {
        if (!this.hasChildren()) {
            return EMPTY_ITERATOR;
        }
        return new Iterator<ExpressionNode>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ExpressionNode.this.node.getChildCount();
            }

            @Override
            public ExpressionNode next() {
                return ExpressionNode.this.from(ExpressionNode.this.node.getChild(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

