/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.reactivestreams.Publisher;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.support.MongodbDocumentSerializer;
import org.springframework.data.mongodb.repository.support.QuerydslAbstractMongodbQuery;
import org.springframework.data.mongodb.repository.support.QuerydslAnyEmbeddedBuilder;
import org.springframework.data.mongodb.repository.support.QuerydslJoinBuilder;
import org.springframework.data.mongodb.repository.support.QuerydslMongoOps;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveSpringDataMongodbQuery<K>
extends QuerydslAbstractMongodbQuery<K, ReactiveSpringDataMongodbQuery<K>> {
    private final Class<K> entityClass;
    private final ReactiveMongoOperations mongoOperations;
    private final ReactiveFindOperation.FindWithProjection<K> find;

    ReactiveSpringDataMongodbQuery(ReactiveMongoOperations mongoOperations, Class<? extends K> entityClass) {
        this(new SpringDataMongodbSerializer(mongoOperations.getConverter()), mongoOperations, entityClass, null);
    }

    ReactiveSpringDataMongodbQuery(MongodbDocumentSerializer serializer, ReactiveMongoOperations mongoOperations, Class<? extends K> entityClass, @Nullable String collection) {
        super(serializer);
        this.entityClass = entityClass;
        this.mongoOperations = mongoOperations;
        this.find = StringUtils.hasText((String)collection) ? mongoOperations.query(this.entityClass).inCollection(collection) : mongoOperations.query(this.entityClass);
    }

    Flux<K> fetch() {
        return this.createQuery().flatMapMany(it -> this.find.matching((Query)it).all());
    }

    Mono<K> fetchOne() {
        return this.createQuery().flatMap(it -> this.find.matching((Query)it).one());
    }

    Mono<Long> fetchCount() {
        return this.createQuery().flatMap(it -> this.find.matching((Query)it).count());
    }

    <T> QuerydslJoinBuilder<ReactiveSpringDataMongodbQuery<K>, K, T> join(Path<T> ref, Path<T> target) {
        return new QuerydslJoinBuilder(this.getQueryMixin(), ref, target);
    }

    <T> QuerydslJoinBuilder<ReactiveSpringDataMongodbQuery<K>, K, T> join(CollectionPathBase<?, T, ?> ref, Path<T> target) {
        return new QuerydslJoinBuilder(this.getQueryMixin(), (Path<?>)ref, target);
    }

    <T> QuerydslAnyEmbeddedBuilder<ReactiveSpringDataMongodbQuery<K>, K> anyEmbedded(Path<? extends Collection<T>> collection, Path<T> target) {
        return new QuerydslAnyEmbeddedBuilder(this.getQueryMixin(), collection);
    }

    protected Mono<Query> createQuery() {
        QueryMetadata metadata = this.getQueryMixin().getMetadata();
        return this.createQuery(this.createFilter(metadata), metadata.getProjection(), metadata.getModifiers(), metadata.getOrderBy());
    }

    protected Mono<Query> createQuery(Mono<Predicate> filter, @Nullable Expression<?> projection, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        return filter.map(this::createQuery).defaultIfEmpty((Object)this.createQuery(null)).map(it -> {
            BasicQuery basicQuery = new BasicQuery((Document)it, this.createProjection(projection));
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                basicQuery.limit(limit);
            }
            if (offset != null) {
                basicQuery.skip(offset.intValue());
            }
            if (orderBy.size() > 0) {
                basicQuery.setSortObject(this.createSort(orderBy));
            }
            return basicQuery;
        });
    }

    protected Mono<Predicate> createFilter(QueryMetadata metadata) {
        if (!metadata.getJoins().isEmpty()) {
            return this.createJoinFilter(metadata).map(it -> ExpressionUtils.allOf((Predicate[])new Predicate[]{metadata.getWhere(), it})).switchIfEmpty(Mono.justOrEmpty((Object)metadata.getWhere()));
        }
        return Mono.justOrEmpty((Object)metadata.getWhere());
    }

    protected Mono<Predicate> createJoinFilter(QueryMetadata metadata) {
        LinkedMultiValueMap predicates = new LinkedMultiValueMap();
        List joins = metadata.getJoins();
        for (int i = joins.size() - 1; i >= 0; --i) {
            JoinExpression join = (JoinExpression)joins.get(i);
            Path source = (Path)((Operation)join.getTarget()).getArg(0);
            Path target = (Path)((Operation)join.getTarget()).getArg(1);
            Collection extraFilters = (Collection)predicates.get((Object)target.getRoot());
            Mono filter = this.allOf(extraFilters).map(it -> ExpressionUtils.allOf((Predicate[])new Predicate[]{join.getCondition(), it})).switchIfEmpty(Mono.justOrEmpty((Object)join.getCondition()));
            Mono predicate = this.getIds(target.getType(), (Mono<Predicate>)filter).collectList().handle((it, sink) -> {
                if (it.isEmpty()) {
                    sink.error((Throwable)new NoMatchException(source));
                    return;
                }
                Path path = ExpressionUtils.path(String.class, (Path)source, (String)"$id");
                sink.next((Object)ExpressionUtils.in((Expression)path, (Collection)it));
            });
            predicates.add((Object)source.getRoot(), (Object)predicate);
        }
        Path source = (Path)((Operation)((JoinExpression)joins.get(0)).getTarget()).getArg(0);
        return this.allOf((Collection)predicates.get((Object)source.getRoot())).onErrorResume(NoMatchException.class, e -> Mono.just((Object)ExpressionUtils.predicate((Operator)QuerydslMongoOps.NO_MATCH, (Expression[])new Expression[]{e.source})));
    }

    private Mono<Predicate> allOf(@Nullable Collection<Mono<Predicate>> predicates) {
        return predicates != null ? Flux.concat(predicates).collectList().map(ExpressionUtils::allOf) : Mono.empty();
    }

    protected Flux<Object> getIds(Class<?> targetType, Mono<Predicate> condition) {
        return condition.flatMapMany(it -> this.getIds(targetType, (Predicate)it)).switchIfEmpty((Publisher)Flux.defer(() -> this.getIds(targetType, (Predicate)null)));
    }

    protected Flux<Object> getIds(Class<?> targetType, @Nullable Predicate condition) {
        return this.createQuery((Mono<Predicate>)Mono.justOrEmpty((Object)condition), null, QueryModifiers.EMPTY, Collections.emptyList()).flatMapMany(query -> this.mongoOperations.findDistinct((Query)query, "_id", targetType, Object.class));
    }

    static class NoMatchException
    extends RuntimeException {
        final Path<?> source;

        NoMatchException(Path<?> source) {
            this.source = source;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

