/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class CollationUtils {
    private static final ParameterBindingDocumentCodec CODEC = new ParameterBindingDocumentCodec();
    private static final Pattern PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");

    @Nullable
    static Collation computeCollation(@Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        if (accessor.getCollation() != null) {
            return accessor.getCollation();
        }
        if (!StringUtils.hasText((String)collationExpression)) {
            return null;
        }
        if (StringUtils.trimLeadingWhitespace((String)collationExpression).startsWith("{")) {
            ParameterBindingContext bindingContext = new ParameterBindingContext(accessor::getBindableValue, expressionParser, () -> evaluationContextProvider.getEvaluationContext((Parameters)parameters, accessor.getValues()));
            return Collation.from(CODEC.decode(collationExpression, bindingContext));
        }
        Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(collationExpression);
        if (!matcher.find()) {
            return Collation.parse(collationExpression);
        }
        String placeholder = matcher.group();
        Object placeholderValue = accessor.getBindableValue(CollationUtils.computeParameterIndex(placeholder));
        if (collationExpression.startsWith("?")) {
            if (placeholderValue instanceof String) {
                return Collation.parse(placeholderValue.toString());
            }
            if (placeholderValue instanceof Locale) {
                return Collation.of((Locale)placeholderValue);
            }
            if (placeholderValue instanceof Document) {
                return Collation.from((Document)placeholderValue);
            }
            throw new IllegalArgumentException(String.format("Collation must be a String, Locale or Document but was %s", ObjectUtils.nullSafeClassName((Object)placeholderValue)));
        }
        return Collation.parse(collationExpression.replace(placeholder, placeholderValue.toString()));
    }

    private static int computeParameterIndex(String parameter) {
        return (Integer)NumberUtils.parseNumber((String)parameter.replace("?", ""), Integer.class);
    }

    private CollationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

