/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultBulkOperations
implements BulkOperations {
    private final MongoOperations mongoOperations;
    private final String collectionName;
    private final BulkOperationContext bulkOperationContext;
    private final List<SourceAwareWriteModelHolder> models = new ArrayList<SourceAwareWriteModelHolder>();
    private PersistenceExceptionTranslator exceptionTranslator;
    @Nullable
    private WriteConcern defaultWriteConcern;
    private BulkWriteOptions bulkOptions;

    DefaultBulkOperations(MongoOperations mongoOperations, String collectionName, BulkOperationContext bulkOperationContext) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.hasText((String)collectionName, (String)"CollectionName must not be null nor empty!");
        Assert.notNull((Object)bulkOperationContext, (String)"BulkOperationContext must not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.bulkOperationContext = bulkOperationContext;
        this.exceptionTranslator = new MongoExceptionTranslator();
        this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(bulkOperationContext.getBulkMode());
    }

    public void setExceptionTranslator(@Nullable PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? new MongoExceptionTranslator() : exceptionTranslator;
    }

    void setDefaultWriteConcern(@Nullable WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public BulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(document, this.collectionName));
        Object source = this.maybeInvokeBeforeConvertCallback(document);
        this.addModel(source, (WriteModel<Document>)new InsertOneModel((Object)this.getMappedObject(source)));
        return this;
    }

    @Override
    public BulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        documents.forEach(this::insert);
        return this;
    }

    @Override
    public BulkOperations updateOne(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateOne(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateOne(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, false);
        }
        return this;
    }

    @Override
    public BulkOperations updateMulti(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateMulti(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateMulti(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, true);
        }
        return this;
    }

    @Override
    public BulkOperations upsert(Query query, Update update) {
        return this.update(query, update, true, true);
    }

    @Override
    public BulkOperations upsert(List<Pair<Query, Update>> updates) {
        for (Pair<Query, Update> update : updates) {
            this.upsert((Query)update.getFirst(), (Update)update.getSecond());
        }
        return this;
    }

    @Override
    public BulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        DeleteOptions deleteOptions = new DeleteOptions();
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((DeleteOptions)deleteOptions).collation(arg_0));
        this.addModel(query, (WriteModel<Document>)new DeleteManyModel((Bson)query.getQueryObject(), deleteOptions));
        return this;
    }

    @Override
    public BulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null!");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public BulkOperations replaceOne(Query query, Object replacement, FindAndReplaceOptions options) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)replacement, (String)"Replacement must not be null!");
        Assert.notNull((Object)options, (String)"Options must not be null!");
        ReplaceOptions replaceOptions = new ReplaceOptions();
        replaceOptions.upsert(options.isUpsert());
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((ReplaceOptions)replaceOptions).collation(arg_0));
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(replacement, this.collectionName));
        Object source = this.maybeInvokeBeforeConvertCallback(replacement);
        this.addModel(source, (WriteModel<Document>)new ReplaceOneModel(this.getMappedQuery((Bson)query.getQueryObject()), (Object)this.getMappedObject(source), replaceOptions));
        return this;
    }

    @Override
    public BulkWriteResult execute() {
        try {
            BulkWriteResult result = this.mongoOperations.execute(this.collectionName, this::bulkWriteTo);
            Assert.state((result != null ? 1 : 0) != 0, (String)"Result must not be null.");
            this.models.forEach(this::maybeEmitAfterSaveEvent);
            this.models.forEach(this::maybeInvokeAfterSaveCallback);
            BulkWriteResult bulkWriteResult = result;
            return bulkWriteResult;
        }
        finally {
            this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(this.bulkOperationContext.getBulkMode());
        }
    }

    private BulkWriteResult bulkWriteTo(MongoCollection<Document> collection) {
        if (this.defaultWriteConcern != null) {
            collection = collection.withWriteConcern(this.defaultWriteConcern);
        }
        return collection.bulkWrite(this.models.stream().map(this::extractAndMapWriteModel).collect(Collectors.toList()), this.bulkOptions);
    }

    private WriteModel<Document> extractAndMapWriteModel(SourceAwareWriteModelHolder it) {
        this.maybeEmitBeforeSaveEvent(it);
        if (it.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)it.getModel()).getDocument();
            this.maybeInvokeBeforeSaveCallback(it.getSource(), target);
        } else if (it.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)it.getModel()).getReplacement();
            this.maybeInvokeBeforeSaveCallback(it.getSource(), target);
        }
        return this.mapWriteModel(it.getModel());
    }

    private BulkOperations update(Query query, Update update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        UpdateOptions options = DefaultBulkOperations.computeUpdateOptions(query, update, upsert);
        if (multi) {
            this.addModel(update, (WriteModel<Document>)new UpdateManyModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        } else {
            this.addModel(update, (WriteModel<Document>)new UpdateOneModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        }
        return this;
    }

    private WriteModel<Document> mapWriteModel(WriteModel<Document> writeModel) {
        if (writeModel instanceof UpdateOneModel) {
            UpdateOneModel model = (UpdateOneModel)writeModel;
            return new UpdateOneModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof UpdateManyModel) {
            UpdateManyModel model = (UpdateManyModel)writeModel;
            return new UpdateManyModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof DeleteOneModel) {
            DeleteOneModel model = (DeleteOneModel)writeModel;
            return new DeleteOneModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        if (writeModel instanceof DeleteManyModel) {
            DeleteManyModel model = (DeleteManyModel)writeModel;
            return new DeleteManyModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        return writeModel;
    }

    private Bson getMappedUpdate(Bson update) {
        return ((QueryMapper)this.bulkOperationContext.getUpdateMapper()).getMappedObject(update, this.bulkOperationContext.getEntity());
    }

    private Bson getMappedQuery(Bson query) {
        return this.bulkOperationContext.getQueryMapper().getMappedObject(query, this.bulkOperationContext.getEntity());
    }

    private Document getMappedObject(Object source) {
        if (source instanceof Document) {
            return (Document)source;
        }
        Document sink = new Document();
        this.mongoOperations.getConverter().write(source, sink);
        return sink;
    }

    private void addModel(Object source, WriteModel<Document> model) {
        this.models.add(new SourceAwareWriteModelHolder(source, model));
    }

    private void maybeEmitBeforeSaveEvent(SourceAwareWriteModelHolder holder) {
        if (holder.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.getModel()).getDocument();
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        } else if (holder.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.getModel()).getReplacement();
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        }
    }

    private void maybeEmitAfterSaveEvent(SourceAwareWriteModelHolder holder) {
        if (holder.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.getModel()).getDocument();
            this.maybeEmitEvent(new AfterSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        } else if (holder.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.getModel()).getReplacement();
            this.maybeEmitEvent(new AfterSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        }
    }

    private void maybeInvokeAfterSaveCallback(SourceAwareWriteModelHolder holder) {
        if (holder.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.getModel()).getDocument();
            this.maybeInvokeAfterSaveCallback(holder.getSource(), target);
        } else if (holder.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.getModel()).getReplacement();
            this.maybeInvokeAfterSaveCallback(holder.getSource(), target);
        }
    }

    private <E extends MongoMappingEvent<T>, T> E maybeEmitEvent(E event) {
        if (this.bulkOperationContext.getEventPublisher() == null) {
            return event;
        }
        this.bulkOperationContext.getEventPublisher().publishEvent(event);
        return event;
    }

    private Object maybeInvokeBeforeConvertCallback(Object value) {
        if (this.bulkOperationContext.getEntityCallbacks() == null) {
            return value;
        }
        return this.bulkOperationContext.getEntityCallbacks().callback(BeforeConvertCallback.class, value, new Object[]{this.collectionName});
    }

    private Object maybeInvokeBeforeSaveCallback(Object value, Document mappedDocument) {
        if (this.bulkOperationContext.getEntityCallbacks() == null) {
            return value;
        }
        return this.bulkOperationContext.getEntityCallbacks().callback(BeforeSaveCallback.class, value, new Object[]{mappedDocument, this.collectionName});
    }

    private Object maybeInvokeAfterSaveCallback(Object value, Document mappedDocument) {
        if (this.bulkOperationContext.getEntityCallbacks() == null) {
            return value;
        }
        return this.bulkOperationContext.getEntityCallbacks().callback(AfterSaveCallback.class, value, new Object[]{mappedDocument, this.collectionName});
    }

    private static BulkWriteOptions getBulkWriteOptions(BulkOperations.BulkMode bulkMode) {
        BulkWriteOptions options = new BulkWriteOptions();
        switch (bulkMode) {
            case ORDERED: {
                return options.ordered(true);
            }
            case UNORDERED: {
                return options.ordered(false);
            }
        }
        throw new IllegalStateException("BulkMode was null!");
    }

    private static UpdateOptions computeUpdateOptions(Query filterQuery, UpdateDefinition update, boolean upsert) {
        UpdateOptions options = new UpdateOptions();
        options.upsert(upsert);
        if (update.hasArrayFilters()) {
            ArrayList<Document> list = new ArrayList<Document>(update.getArrayFilters().size());
            for (UpdateDefinition.ArrayFilter arrayFilter : update.getArrayFilters()) {
                list.add(arrayFilter.asDocument());
            }
            options.arrayFilters(list);
        }
        filterQuery.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((UpdateOptions)options).collation(arg_0));
        return options;
    }

    private static final class SourceAwareWriteModelHolder {
        private final Object source;
        private final WriteModel<Document> model;

        public SourceAwareWriteModelHolder(Object source, WriteModel<Document> model) {
            this.source = source;
            this.model = model;
        }

        public Object getSource() {
            return this.source;
        }

        public WriteModel<Document> getModel() {
            return this.model;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceAwareWriteModelHolder)) {
                return false;
            }
            SourceAwareWriteModelHolder other = (SourceAwareWriteModelHolder)o;
            Object this$source = this.getSource();
            Object other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            WriteModel<Document> this$model = this.getModel();
            WriteModel<Document> other$model = other.getModel();
            return !(this$model == null ? other$model != null : !this$model.equals(other$model));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            WriteModel<Document> $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultBulkOperations.SourceAwareWriteModelHolder(source=" + this.getSource() + ", model=" + this.getModel() + ")";
        }
    }

    static final class BulkOperationContext {
        @NonNull
        private final BulkOperations.BulkMode bulkMode;
        @NonNull
        private final Optional<? extends MongoPersistentEntity<?>> entity;
        @NonNull
        private final QueryMapper queryMapper;
        @NonNull
        private final UpdateMapper updateMapper;
        private final ApplicationEventPublisher eventPublisher;
        private final EntityCallbacks entityCallbacks;

        public BulkOperationContext(@NonNull BulkOperations.BulkMode bulkMode, @NonNull Optional<? extends MongoPersistentEntity<?>> entity, @NonNull QueryMapper queryMapper, @NonNull UpdateMapper updateMapper, ApplicationEventPublisher eventPublisher, EntityCallbacks entityCallbacks) {
            if (bulkMode == null) {
                throw new IllegalArgumentException("bulkMode is marked non-null but is null");
            }
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked non-null but is null");
            }
            if (queryMapper == null) {
                throw new IllegalArgumentException("queryMapper is marked non-null but is null");
            }
            if (updateMapper == null) {
                throw new IllegalArgumentException("updateMapper is marked non-null but is null");
            }
            this.bulkMode = bulkMode;
            this.entity = entity;
            this.queryMapper = queryMapper;
            this.updateMapper = updateMapper;
            this.eventPublisher = eventPublisher;
            this.entityCallbacks = entityCallbacks;
        }

        @NonNull
        public BulkOperations.BulkMode getBulkMode() {
            return this.bulkMode;
        }

        @NonNull
        public Optional<? extends MongoPersistentEntity<?>> getEntity() {
            return this.entity;
        }

        @NonNull
        public QueryMapper getQueryMapper() {
            return this.queryMapper;
        }

        @NonNull
        public UpdateMapper getUpdateMapper() {
            return this.updateMapper;
        }

        public ApplicationEventPublisher getEventPublisher() {
            return this.eventPublisher;
        }

        public EntityCallbacks getEntityCallbacks() {
            return this.entityCallbacks;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkOperationContext)) {
                return false;
            }
            BulkOperationContext other = (BulkOperationContext)o;
            BulkOperations.BulkMode this$bulkMode = this.getBulkMode();
            BulkOperations.BulkMode other$bulkMode = other.getBulkMode();
            if (this$bulkMode == null ? other$bulkMode != null : !((Object)((Object)this$bulkMode)).equals((Object)other$bulkMode)) {
                return false;
            }
            Optional<MongoPersistentEntity<?>> this$entity = this.getEntity();
            Optional<? extends MongoPersistentEntity<?>> other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity)) {
                return false;
            }
            QueryMapper this$queryMapper = this.getQueryMapper();
            QueryMapper other$queryMapper = other.getQueryMapper();
            if (this$queryMapper == null ? other$queryMapper != null : !this$queryMapper.equals(other$queryMapper)) {
                return false;
            }
            UpdateMapper this$updateMapper = this.getUpdateMapper();
            UpdateMapper other$updateMapper = other.getUpdateMapper();
            if (this$updateMapper == null ? other$updateMapper != null : !this$updateMapper.equals(other$updateMapper)) {
                return false;
            }
            ApplicationEventPublisher this$eventPublisher = this.getEventPublisher();
            ApplicationEventPublisher other$eventPublisher = other.getEventPublisher();
            if (this$eventPublisher == null ? other$eventPublisher != null : !this$eventPublisher.equals(other$eventPublisher)) {
                return false;
            }
            EntityCallbacks this$entityCallbacks = this.getEntityCallbacks();
            EntityCallbacks other$entityCallbacks = other.getEntityCallbacks();
            return !(this$entityCallbacks == null ? other$entityCallbacks != null : !this$entityCallbacks.equals(other$entityCallbacks));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BulkOperations.BulkMode $bulkMode = this.getBulkMode();
            result = result * 59 + ($bulkMode == null ? 43 : ((Object)((Object)$bulkMode)).hashCode());
            Optional<MongoPersistentEntity<?>> $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
            QueryMapper $queryMapper = this.getQueryMapper();
            result = result * 59 + ($queryMapper == null ? 43 : $queryMapper.hashCode());
            UpdateMapper $updateMapper = this.getUpdateMapper();
            result = result * 59 + ($updateMapper == null ? 43 : $updateMapper.hashCode());
            ApplicationEventPublisher $eventPublisher = this.getEventPublisher();
            result = result * 59 + ($eventPublisher == null ? 43 : $eventPublisher.hashCode());
            EntityCallbacks $entityCallbacks = this.getEntityCallbacks();
            result = result * 59 + ($entityCallbacks == null ? 43 : $entityCallbacks.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultBulkOperations.BulkOperationContext(bulkMode=" + (Object)((Object)this.getBulkMode()) + ", entity=" + this.getEntity() + ", queryMapper=" + this.getQueryMapper() + ", updateMapper=" + this.getUpdateMapper() + ", eventPublisher=" + this.getEventPublisher() + ", entityCallbacks=" + this.getEntityCallbacks() + ")";
        }
    }
}

