/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationRenderer;
import org.springframework.data.mongodb.core.aggregation.MergeOperation;
import org.springframework.data.mongodb.core.aggregation.OutOperation;
import org.springframework.util.Assert;

public class AggregationPipeline {
    private final List<AggregationOperation> pipeline;

    public AggregationPipeline() {
        this(new ArrayList<AggregationOperation>());
    }

    public AggregationPipeline(List<AggregationOperation> aggregationOperations) {
        this.pipeline = new ArrayList<AggregationOperation>(aggregationOperations);
    }

    public AggregationPipeline add(AggregationOperation aggregationOperation) {
        Assert.notNull((Object)aggregationOperation, (String)"AggregationOperation must not be null!");
        this.pipeline.add(aggregationOperation);
        return this;
    }

    public List<AggregationOperation> getOperations() {
        return Collections.unmodifiableList(this.pipeline);
    }

    List<Document> toDocuments(AggregationOperationContext context) {
        this.verify();
        return AggregationOperationRenderer.toDocument(this.pipeline, context);
    }

    public boolean isOutOrMerge() {
        if (this.pipeline.isEmpty()) {
            return false;
        }
        String operator = this.pipeline.get(this.pipeline.size() - 1).getOperator();
        return operator.equals("$out") || operator.equals("$merge");
    }

    void verify() {
        for (AggregationOperation aggregationOperation : this.pipeline) {
            if (aggregationOperation instanceof OutOperation && !this.isLast(aggregationOperation)) {
                throw new IllegalArgumentException("The $out operator must be the last stage in the pipeline.");
            }
            if (!(aggregationOperation instanceof MergeOperation) || this.isLast(aggregationOperation)) continue;
            throw new IllegalArgumentException("The $merge operator must be the last stage in the pipeline.");
        }
    }

    private boolean isLast(AggregationOperation aggregationOperation) {
        return this.pipeline.indexOf(aggregationOperation) == this.pipeline.size() - 1;
    }
}

