/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.aot;

import java.util.function.Predicate;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.data.util.TypeUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class MongoAotPredicates {
    public static final Predicate<Class<?>> IS_SIMPLE_TYPE = type -> MongoSimpleTypes.HOLDER.isSimpleType(type) || TypeUtils.type((Class)type).isPartOf(new String[]{"org.bson"});
    public static final Predicate<ReactiveWrappers.ReactiveLibrary> IS_REACTIVE_LIBARARY_AVAILABLE = lib -> ReactiveWrappers.isAvailable((ReactiveWrappers.ReactiveLibrary)lib);
    public static final Predicate<ClassLoader> IS_SYNC_CLIENT_PRESENT = classLoader -> ClassUtils.isPresent((String)"com.mongodb.client.MongoClient", (ClassLoader)classLoader);

    public static boolean isReactorPresent() {
        return IS_REACTIVE_LIBARARY_AVAILABLE.test(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR);
    }

    public static boolean isSyncClientPresent(@Nullable ClassLoader classLoader) {
        return IS_SYNC_CLIENT_PRESENT.test(classLoader);
    }
}

