/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.client.MongoCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoDatabaseUtils;
import org.springframework.data.mongodb.core.convert.ReferenceLoader;
import org.springframework.data.mongodb.core.convert.ReferenceResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoDatabaseFactoryReferenceLoader
implements ReferenceLoader {
    private static final Log LOGGER = LogFactory.getLog(MongoDatabaseFactoryReferenceLoader.class);
    private final MongoDatabaseFactory mongoDbFactory;

    public MongoDatabaseFactoryReferenceLoader(MongoDatabaseFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory translator must not be null");
        this.mongoDbFactory = mongoDbFactory;
    }

    @Override
    public Iterable<Document> fetchMany(ReferenceLoader.DocumentReferenceQuery referenceQuery, ReferenceResolver.ReferenceCollection context) {
        MongoCollection<Document> collection = this.getCollection(context);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)String.format("Bulk fetching %s from %s.%s", referenceQuery, StringUtils.hasText((String)context.getDatabase()) ? context.getDatabase() : collection.getNamespace().getDatabaseName(), context.getCollection()));
        }
        return referenceQuery.apply(collection);
    }

    protected MongoCollection<Document> getCollection(ReferenceResolver.ReferenceCollection context) {
        return MongoDatabaseUtils.getDatabase(context.getDatabase(), this.mongoDbFactory).getCollection(context.getCollection(), Document.class);
    }
}

