/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.path.NodePath;
import org.springframework.data.neo4j.support.path.RelationshipPath;

public class DefaultConverter<T, R>
implements ResultConverter<T, R> {
    @Override
    public R convert(Object value, Class type) {
        return this.convert(value, type, (MappingPolicy)null);
    }

    @Override
    public R convert(Object value, Class type, MappingPolicy mappingPolicy) {
        if (value == null || type.isInstance(value)) {
            return (R)value;
        }
        Object singleValue = this.extractValue(value);
        if (singleValue == null || type.isInstance(singleValue)) {
            return (R)singleValue;
        }
        Class<?> sourceType = singleValue.getClass();
        Object result = this.doConvert(singleValue, sourceType, type, mappingPolicy);
        if (result == null) {
            throw new RuntimeException("Cannot automatically convert " + sourceType + " to " + type + " please use a custom converter");
        }
        return (R)result;
    }

    protected Object extractValue(Object value) {
        if (value instanceof Path) {
            return value;
        }
        if (value instanceof Map) {
            return this.extractSingle(((Map)value).values());
        }
        if (value instanceof Iterable) {
            return this.extractSingle((Iterable)value);
        }
        return value;
    }

    private Object extractSingle(Iterable values) {
        Iterator it = values.iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("Cannot extract single value from empty Iterable.");
        }
        Object result = it.next();
        if (it.hasNext()) {
            throw new RuntimeException("Cannot extract single value from Iterable with more than one elements.");
        }
        return result;
    }

    protected Object doConvert(Object value, Class<?> sourceType, Class type, MappingPolicy mappingPolicy) {
        if (Node.class.isAssignableFrom(type)) {
            return this.toNode(value, sourceType);
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return this.toRelationship(value, sourceType);
        }
        if (Path.class.isAssignableFrom(type)) {
            return this.toPath(value, sourceType);
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value.toString());
        }
        return null;
    }

    public Path toPath(Object value, Class<?> sourceType) {
        if (Node.class.isAssignableFrom(sourceType)) {
            return new NodePath((Node)value);
        }
        if (Relationship.class.isAssignableFrom(sourceType)) {
            return new RelationshipPath((Relationship)value);
        }
        if (Path.class.isAssignableFrom(sourceType)) {
            return (Path)value;
        }
        return null;
    }

    public Relationship toRelationship(Object value, Class<?> sourceType) {
        if (Relationship.class.isAssignableFrom(sourceType)) {
            return (Relationship)value;
        }
        if (Path.class.isAssignableFrom(sourceType)) {
            return ((Path)value).lastRelationship();
        }
        if (Node.class.isAssignableFrom(sourceType)) {
            return (Relationship)((Node)value).getRelationships().iterator().next();
        }
        return null;
    }

    public Node toNode(Object value, Class<?> sourceType) {
        if (Node.class.isAssignableFrom(sourceType)) {
            return (Node)value;
        }
        if (Path.class.isAssignableFrom(sourceType)) {
            return ((Path)value).endNode();
        }
        if (Relationship.class.isAssignableFrom(sourceType)) {
            return ((Relationship)value).getEndNode();
        }
        return null;
    }
}

