/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jEdge;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jVertex;
import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.IterableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinExecutor {
    public static final Logger log = LoggerFactory.getLogger(GremlinExecutor.class);
    public static final int REFRESH_ENGINE_COUNT = 10000;
    private static final String GRAPH_VARIABLE = "g";
    private volatile ScriptEngine engine;
    private static final AtomicInteger executionCount = new AtomicInteger();
    private final GraphDatabaseService graphDatabaseService;

    private ScriptEngine createScriptEngine() {
        return new ScriptEngineManager().getEngineByName("gremlin-groovy");
    }

    public GremlinExecutor(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public Iterable<Object> query(String statement, Map<String, Object> params) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Executing gremlin query: %s params %s", statement, params));
            }
            Bindings bindings = this.createBindings(params);
            ScriptEngine engine = this.engine();
            Object result = engine.eval(statement, bindings);
            return GremlinExecutor.getRepresentation(result);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error executing statement " + statement, e);
        }
    }

    private Bindings createBindings(Map<String, Object> params) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put(GRAPH_VARIABLE, (Object)new Neo4jGraph(this.graphDatabaseService, false));
        if (params == null) {
            return bindings;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            bindings.put(entry.getKey(), entry.getValue());
        }
        return bindings;
    }

    private ScriptEngine engine() {
        if (this.engine == null || executionCount.incrementAndGet() > 10000) {
            executionCount.set(0);
            this.engine = this.createScriptEngine();
        }
        return this.engine;
    }

    public static Iterable getRepresentation(Object result) {
        if (result instanceof Iterable) {
            if (result instanceof Table) {
                final Table table = (Table)result;
                return new IterableWrapper<Map<String, Object>, Row>((Iterable)table){

                    protected Map<String, Object> underlyingObjectToObject(Row row) {
                        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                        for (String column : table.getColumnNames()) {
                            result.put(column, row.getColumn(column));
                        }
                        return result;
                    }
                };
            }
            return new IterableWrapper((Iterable)result){

                protected Object underlyingObjectToObject(Object object) {
                    return GremlinExecutor.getSingleResult(object);
                }
            };
        }
        return Collections.singleton(GremlinExecutor.getSingleResult(result));
    }

    private static Object getSingleResult(Object result) {
        if (result instanceof Vertex) {
            return ((Neo4jVertex)result).getRawVertex();
        }
        if (result instanceof Edge) {
            return ((Neo4jEdge)result).getRawEdge();
        }
        if (result instanceof Neo4jGraph) {
            return ((Neo4jGraph)result).getRawGraph();
        }
        return result;
    }
}

