/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.transaction.SessionFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SharedSessionCreator {
    private static final Set<String> transactionRequiringMethods = new HashSet<String>(4);

    public static Session createSharedSession(SessionFactory sessionFactory) {
        return (Session)Proxy.newProxyInstance(SharedSessionCreator.class.getClassLoader(), new Class[]{Session.class}, (InvocationHandler)new SharedSessionInvocationHandler(sessionFactory));
    }

    static {
        transactionRequiringMethods.add("deleteAll");
        transactionRequiringMethods.add("save");
        transactionRequiringMethods.add("delete");
        transactionRequiringMethods.add("purgeDatabase");
    }

    private static class SharedSessionInvocationHandler
    implements InvocationHandler {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final SessionFactory targetFactory;
        private final ClassLoader proxyClassLoader;

        public SharedSessionInvocationHandler(SessionFactory target) {
            this.targetFactory = target;
            this.proxyClassLoader = this.targetFactory.getClass().getClassLoader();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("toString")) {
                return "Shared Session proxy for target factory [" + this.targetFactory + "]";
            }
            if (method.getName().equals("beginTransaction")) {
                throw new IllegalStateException("Not allowed to create transaction on shared Session - use Spring transactions instead");
            }
            Session target = SessionFactoryUtils.getSession(this.targetFactory);
            if (transactionRequiringMethods.contains(method.getName()) && (target == null || !TransactionSynchronizationManager.isActualTransactionActive() && target.getTransaction() != null && EnumSet.of(Transaction.Status.CLOSED, Transaction.Status.COMMITTED, Transaction.Status.ROLLEDBACK).contains(target.getTransaction().status()))) {
                throw new IllegalStateException("No Session with actual transaction available for current thread - cannot reliably process '" + method.getName() + "' call");
            }
            boolean isNewSession = false;
            if (target == null) {
                this.logger.debug("Creating new Session for shared Session invocation");
                target = this.targetFactory.openSession();
                isNewSession = true;
            }
            try {
                Object object = method.invoke((Object)target, args);
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (isNewSession) {
                    SessionFactoryUtils.closeSession(target);
                }
            }
        }
    }
}

